package com.ejianc.business.sub.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.OddjobContentEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.OddjobContentVo;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包零星用工表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("oddjob")
public class OddjobController implements Serializable {

    @Autowired
    IOddjobService oddjobService;

    @Autowired
    private IOrgApi orgApi;


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param oddjobVO
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddjobVO> saveOrUpdate(@RequestBody OddjobVO oddjobVO) {
        OddjobVO vo = oddjobService.insertOrUpdate(oddjobVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetail(Long id) {
        OddjobVO vo = oddjobService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> queryList(@RequestBody QueryParam param) {
        return oddjobService.queryListVOs(param);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddjobVO> vos) {
        return  oddjobService.deleteByIds(vos);
    }

    /**
     * 零工参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/oddjobRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> oddjobRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                         @RequestParam(defaultValue = "10") Integer pageSize,
                                                         @RequestParam(value = "condition", required = false) String condition,
                                                         @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("bill_code");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isNotBlank(searchText)) {
            queryParam.setSearchText(searchText);
        }

        Long contractId = null;
        Long orgId = null;
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        }
        if(null != orgId) {
            queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if(null == contractId) {
            return CommonResponse.success("查询零工列表失败，合同主键为必传参数！", null);
        }
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        if(projectId != null){
            queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.getParams().put("settle_flag", new Parameter(QueryParam.EQ, Boolean.FALSE));
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        IPage<OddjobEntity> pageData = oddjobService.queryPage(queryParam, false);
        IPage<OddjobVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), OddjobVO.class));
        return CommonResponse.success("查询合同列表成功！", result);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增查询合同转化为零工
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetailAdd(Long contractId) {
        OddjobVO vo = oddjobService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为零工成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobRecordVO> queryDetailRecord(Long id) {
        OddjobRecordVO vo = oddjobService.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！",vo);
    }

    /**
     * 导出
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        oddjobService.excelExport(param,response);
    }

    /**
     * 零星用工内容导出
     * @param oddjobVO
     * @param response
     */
    @PostMapping("excelExportContentList")
    public void excelExportContentList(@RequestBody OddjobVO oddjobVO,HttpServletResponse response){
        OddjobEntity entity = oddjobService.selectById(oddjobVO.getId());
        Map<String, Object> beans = new HashMap();
        List<OddjobContentVo> list = new ArrayList<>();
        List<OddjobContentEntity> data = entity.getOddjobContentList();
        if(CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                OddjobContentVo vo = BeanMapper.map(item, OddjobContentVo.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("oddjobContentExport.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "oddjobContent-import.xlsx", "零星用工内容导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<OddjobContentVo> successList = new ArrayList<>();
            List<OddjobContentVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 5) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    OddjobContentVo oddjobContentVo = new OddjobContentVo();
                    oddjobContentVo.setName(datas.get(0));
                    if(StringUtils.isBlank(datas.get(1))){
                        oddjobContentVo.setErrorMessage("单价为必填项");
                    }else{
                        oddjobContentVo.setPrice(new BigDecimal(datas.get(1)));
                    }
                    if(StringUtils.isBlank(datas.get(2))){
                        oddjobContentVo.setErrorMessage("数量为必填项");
                    }else{
                        oddjobContentVo.setNum(new BigDecimal(datas.get(2)));
                    }
                    BigDecimal money = ComputeUtil.safeMultiply(oddjobContentVo.getPrice(),oddjobContentVo.getNum());
                    if(!"".equals(datas.get(3)) && datas.get(3) != null){
                        if(money.equals(new BigDecimal(datas.get(3)))){
                            oddjobContentVo.setMoney(new BigDecimal(datas.get(3)));
                        }else{
                            oddjobContentVo.setMoney(money);
                        }
                    }else{
                            oddjobContentVo.setMoney(money);
                    }
                    oddjobContentVo.setMemo(datas.get(4));

                    if (StringUtils.isBlank(oddjobContentVo.getErrorMessage())) {
                        successList.add(oddjobContentVo);
                    }else{
                        errorList.add(oddjobContentVo);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /***
     * @description: 参数校验
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkAllParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody OddjobVO vo){
        ParamsCheckVO paramsCheckVO = oddjobService.checkAllParams(vo);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /***
     * 根据合同id 查询 合同累计收款
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySumOddjobMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobVO> querySumOddjobMny(Long contractId){
        OddjobVO oddjobVO = oddjobService.querySumOddjobMny(contractId);
        return CommonResponse.success("查询数据成功！",oddjobVO);
    }

}
