package com.ejianc.business.sub.controller;

import java.io.Serializable;

import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.sub.bean.WorkerPresentDetailEntity;
import com.ejianc.business.sub.vo.WorkerPresentDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sub.bean.WorkerPresentEntity;
import com.ejianc.business.sub.service.IWorkerPresentService;
import com.ejianc.business.sub.vo.WorkerPresentVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 工人在场统计
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workerPresent")
public class WorkerPresentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "WORKER_PRESENT";//此处需要根据实际修改

    @Autowired
    private IWorkerPresentService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDefdocApi defdocApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerPresentVO> saveOrUpdate(@RequestBody WorkerPresentVO saveOrUpdateVO) {
    	WorkerPresentEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerPresentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    	    if(StringUtils.isEmpty(entity.getBillCode())){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }else{
    	        //校验编码唯一性
                WorkerPresentVO voByCode = service.checkCode(saveOrUpdateVO.getBillCode());
                if(null != voByCode && (null == saveOrUpdateVO.getId() || !voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                    return CommonResponse.error("保存失败，编码重复！");
                }
            }
    	    //根据项目，供应商，合同校验单据
            WorkerPresentVO checkVo = service.checkWorkerPresent(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getSupplierId(), saveOrUpdateVO.getContractId());
            if(null != checkVo && (null == saveOrUpdateVO.getId() || !checkVo.getId().equals(saveOrUpdateVO.getId()))) {
                return CommonResponse.error("保存失败，该合同下分包单位已存在统计表，请更换合同或者分包单位！");
            }
        }
    	service.saveOrUpdate(entity, false);
    	WorkerPresentVO vo = BeanMapper.map(entity, WorkerPresentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkerPresentVO> queryDetail(Long id) {
    	WorkerPresentEntity entity = service.selectById(id);
    	WorkerPresentVO vo = BeanMapper.map(entity, WorkerPresentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerPresentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkerPresentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkerPresentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkerPresentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<WorkerPresentEntity> page = service.queryPage(param,false);
        IPage<WorkerPresentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerPresentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkerPresentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("workerPresent-export.xlsx", beans, response);
    }

    /**
     * 工人在场统计明细导出
     * @param workerPresentVO
     * @param response
     */
    @PostMapping("excelDetailExport")
    public void excelDetailExport(@RequestBody WorkerPresentVO workerPresentVO, HttpServletResponse response){
        WorkerPresentEntity entity = service.selectById(workerPresentVO.getId());
        Map<String, Object> beans = new HashMap();
        List<WorkerPresentDetailVO> list = new ArrayList<>();
        List<WorkerPresentDetailEntity> workerPresentDetailList = entity.getWorkerPresentDetailList();
        if(CollectionUtils.isNotEmpty(workerPresentDetailList)){
            workerPresentDetailList.forEach(item->{
                WorkerPresentDetailVO vo = BeanMapper.map(item, WorkerPresentDetailVO.class);
                //获取工种档案
                CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("worker-present-type");
                Map<String,String> defMap =getDefMapByCode(defList.getData());
                vo.setWorkTypeName(defMap.get(vo.getWorkType()+""));
                if(vo.getPresentFlag()){
                    vo.setPresentFlagStr("是");
                }else{
                    vo.setPresentFlagStr("否");
                }
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("workerPresent-detail-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "workerPresent-import.xlsx", "工人在场统计导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response){
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = com.ejianc.business.utils.ExcelReader.readExcel(mf);
            List<WorkerPresentDetailVO> successList = new ArrayList<>();
            List<WorkerPresentDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 10) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    WorkerPresentDetailVO workerPresentDetailVO = new WorkerPresentDetailVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        workerPresentDetailVO.setErrorMessage("工人姓名为必填项");
                    } else if (datas.get(0).length() > 20) {
                        workerPresentDetailVO.setErrorMessage("物资分类填写长度为2~20字");
                    } else {
                        workerPresentDetailVO.setWorkerName(datas.get(0));
                    }
                    if(StringUtils.isBlank(datas.get(1))){
                        workerPresentDetailVO.setErrorMessage("工种为必填项");
                    }else{
                        CommonResponse<List<DefdocDetailVO>> defList = defdocApi.getDefDocByDefCode("worker-present-type");
                        Map<String,String> defMap =getDefMapByName(defList.getData());
                        String workTypeName = datas.get(1);
                        if(defMap.containsKey(workTypeName.trim())){
                            workerPresentDetailVO.setWorkType(Long.valueOf(defMap.get(workTypeName)));
                            workerPresentDetailVO.setWorkTypeName(workTypeName.trim());
                        }
                    }

                    //手机号、身份证号、银行卡号
                    workerPresentDetailVO.setPhone(datas.get(2));
                    workerPresentDetailVO.setIdCard(datas.get(3));
                    workerPresentDetailVO.setBankAccount(datas.get(4));
                    //如果识别为小数类型，需截取字符串 begin
                    if(workerPresentDetailVO.getPhone().indexOf(".")!=-1){
                        String phone = workerPresentDetailVO.getPhone();
                        phone = phone.substring(0,phone.indexOf("."));
                        workerPresentDetailVO.setPhone(phone);
                    }
                    if(workerPresentDetailVO.getIdCard().indexOf(".")!=-1){
                        String idCard = workerPresentDetailVO.getIdCard();
                        idCard = idCard.substring(0,idCard.indexOf("."));
                        workerPresentDetailVO.setIdCard(idCard);
                    }
                    if(workerPresentDetailVO.getBankAccount().indexOf(".")!=-1){
                        String bankAccount = workerPresentDetailVO.getBankAccount();
                        bankAccount = bankAccount.substring(0,bankAccount.indexOf("."));
                        workerPresentDetailVO.setBankAccount(bankAccount);
                    }
                    //end
                    if (StringUtils.isBlank(datas.get(5))) {
                        workerPresentDetailVO.setErrorMessage("进场日期为必填项");
                    } else {
                        try{
                            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                            String time = datas.get(5);
                            Date date = ft.parse(time);
                            workerPresentDetailVO.setEnterDate(date);
                        }catch (Exception e){
                            workerPresentDetailVO.setErrorMessage("进场日期格式有误，例如2022-01-01");
                            //throw new BusinessException("进场日期格式有误，请确认格式为yyyy-MM-dd");
                        }
                    }
                    if (StringUtils.isBlank(datas.get(6))) {
                        workerPresentDetailVO.setErrorMessage("是否在场为必填项");
                    } else {
                        if("是".equals(datas.get(6))){
                            workerPresentDetailVO.setPresentFlag(true);
                        }else{
                            workerPresentDetailVO.setPresentFlag(false);
                        }
                    }
                    if (StringUtils.isBlank(datas.get(7))) {
                        workerPresentDetailVO.setErrorMessage("离场日期为必填项");
                    } else {
                        try {
                            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                            String time = datas.get(7);
                            Date date = ft.parse(time);
                            workerPresentDetailVO.setDepartureDate(date);
                        }catch (Exception e){
                            workerPresentDetailVO.setErrorMessage("离场日期格式有误，例如2022-01-01");
                            //throw new BusinessException("离场日期格式有误，请确认格式为yyyy-MM-dd");
                        }
                    }
                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9).length() > 50) {
                        workerPresentDetailVO.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        workerPresentDetailVO.setMemo(datas.get(9));
                    }

                    //判断离场日期小于进场日期时，错误提示
                    if(workerPresentDetailVO.getEnterDate() != null && workerPresentDetailVO.getDepartureDate() != null){
                        if(workerPresentDetailVO.getDepartureDate().compareTo(workerPresentDetailVO.getEnterDate())<0){
                            workerPresentDetailVO.setErrorMessage("离场日期不能小于进场日期");
                        }
                    }

                    if (StringUtils.isBlank(workerPresentDetailVO.getErrorMessage())) {
                        successList.add(workerPresentDetailVO);
                        Integer days = daysBetween(workerPresentDetailVO.getEnterDate(), workerPresentDetailVO.getDepartureDate());
                        workerPresentDetailVO.setPresentDays(days+1);
                    }else{
                        errorList.add(workerPresentDetailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refWorkerPresentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerPresentVO>> refWorkerPresentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkerPresentEntity> page = service.queryPage(param,false);
        IPage<WorkerPresentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerPresentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 计算天数
     * @param one
     * @param two
     * @return
     */
     private static Integer daysBetween(Date one,Date two){
        Long  diff = (one.getTime() - two.getTime())/86400000;
         long abs = Math.abs(diff);
         String date = String.valueOf(abs);
         return Integer.parseInt(date);
     }

    public Map<String, String> getDefMapByCode(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getInnerCode, DefdocDetailVO::getName));
    }

    public Map<String, String> getDefMapByName(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }
}
