package com.ejianc.business.sub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/subWarn/")
public class SubWarnApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractService contractService;

    /**
     * 租户下，按照项目分类，支出合同累计金额-分包合同累计
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "subProjectOutMny")
    public CommonResponse<List<SubWarnVo>> subProjectOutMny(@RequestBody List<Long> tenantIds) {
        return CommonResponse.success("获取分包合同支出累计",contractService.subProjectOutMny(tenantIds));
    }
}
