package com.ejianc.business.sub.mapper;

import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.vo.SqlParam;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    List<Map<String, Object>> payMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> prePayMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> finishMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> invoicePayMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> invoiceContractMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<SubWarnVo> subProjectOutMny(@Param(value = "tenantIds")List<Long> tenantIds);

    List<SubProjectReportVo> getMonthSubMny(@Param(value = "projectId")Long projectId,@Param(value = "lastDay") Integer lastDay);

    BigDecimal getSubContract(@Param(value = "projectId")Long projectId);

    List<SubProjectSettleNumVO> getSubSettleNum(@Param(value = "projectIds")List<Long> projectIds);
}
