package com.ejianc.business.sub.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.voucher.service.IVoucherService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 分包过程结算表 服务类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public interface ISettleService extends IBaseService<SettleEntity>, IVoucherService<SettleEntity> {

    SettleVO insertOrUpdate(SettleVO settleVO);

    SettleVO queryDetail(Long id, Boolean detailHasChildren);

    CommonResponse<IPage<SettleVO>> queryListVOs(QueryParam param);

    CommonResponse<String> deleteByIds(List<SettleVO> vos);

    SettleRecordVO queryDetailRecord(Long id);

    SettleVO queryDetailAdd(Long contractId);

    JSONObject querySubSettleVOList(QueryParam param, boolean isEs);

    CommonResponse<SettleVO> pushCost(SettleVO settleVO);

    void costPush(SettleEntity settleEntity);

    void pullCost(Long id);

    ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny);

    SettleVO getSumSettleNumInfo(SettleVO settleVO);

    List<ContractDetailVO> getSumSettleNum(List<ContractDetailVO> contractDetailVOS);

    /**
     * 根据清单编码和名称查询历史数据的含本期累计结算工程量
     * @param settleDetailVO
     * @return
     */
    JSONObject querySettleDetailHistory(SettleDetailVO settleDetailVO);
    /**
     * 查询合同内的历史数据集合，修改含本期累计结算工程量和不含本期累计结算工程量
     * @return
     */
    void updateSettleDetailHistory();

    SettleVO queryProjectAndLaborMny(Long projectId, String settleDate, Long settleId);

    ParamsCheckVO checkParamsByContractNumAndMny(SettleCheckParamsVO settleCheckParamsVO);

}
