package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.*;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.service.*;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包变更表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("change")
public class ChangeBpmServiceImpl  implements ICommonBusinessService {


    @Autowired
    private IChangeService changeService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IContractClauseService contractClauseService;

    @Autowired
    private IContractStageService contractStageService;

    @Autowired
    private IRecordService recordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        /**更新变更的审批时间  begin */
        ChangeEntity changeEntity = changeService.selectById(billId);
        LambdaUpdateWrapper<ChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ChangeEntity::getUsedTime, new Date());
        updateWrapper.eq(ChangeEntity::getId, changeEntity.getId());
        changeService.update(changeEntity, updateWrapper, false);
        /**更新变更的审批时间  end */

        /**复制合同表数据到记录表 begin */
        ContractVO contractVO = contractService.queryDetail(changeEntity.getContractId(), false);
        Map<Long, Integer> contIdVersionMap =  new HashMap<>();
        RecordEntity recordEntity = BeanMapper.map(contractVO, RecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getDetailList())){
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getClauseList())){
            recordEntity.getClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getStageList())){
            recordEntity.getStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setId(null);
            });
        }
        recordService.saveOrUpdate(recordEntity, false);
        /**复制合同表数据到记录表 end */

        /**更新变更表表头数据到合同 begin */
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setContractType(changeEntity.getContractType());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxMny(changeEntity.getTaxMny());
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        contractEntity.setInvoiceType(changeEntity.getInvoiceType());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractService.updateById(contractEntity);
        /**复制合同表数据到记录表 end */

        /**复制合同子表数据到记录表 begin */
        ContractEntity contractChangeEntity = BeanMapper.map(changeEntity, ContractEntity.class);
        List<ContractDetailEntity> contractDetailList = contractChangeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(contractDetailList)){
            contractDetailList.forEach(contractDetailEntity -> {
                //记录虚拟父子关系
                contractDetailEntity.setTid(contractDetailEntity.getId().toString());
                contractDetailEntity.setTpid(contractDetailEntity.getParentId()!= null&&contractDetailEntity.getParentId()>0?contractDetailEntity.getParentId().toString():"");
                Long contractBid = contractDetailEntity.getSrcBid();
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setSrcBid(contractDetailEntity.getId());
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
            });
            contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);

            //根据更新后数据维护树形关系
            Map<String,Long> idMap=new HashMap<>();
            contractDetailList.forEach(cdEntity ->{
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            });

            contractDetailList.forEach(cdEntity ->{
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            });

            contractDetailService.saveOrUpdateBatch(contractDetailList, contractDetailList.size(), false);
        }

        //先删除合同条款表
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        if(CollectionUtils.isNotEmpty(contractClauseList)){
            contractClauseService.removeByIds(contractClauseList.stream().map(ContractClauseEntity::getId).collect(Collectors.toList()),false);
        }

        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if(CollectionUtils.isNotEmpty(contractChangeClauseList)){
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setId(null);
                clauseEntity.setContractId(changeEntity.getContractId());
            });
            contractClauseService.saveOrUpdateBatch(contractChangeClauseList, contractChangeClauseList.size(), false);
        }

        //先删除合同阶段表
        List<ContractStageEntity> stageList = contractEntity.getStageList();
        if(CollectionUtils.isNotEmpty(stageList)){
            contractStageService.removeByIds(stageList.stream().map(ContractStageEntity::getId).collect(Collectors.toList()),false);
        }

        List<ContractStageEntity> stageChangeList = contractChangeEntity.getStageList();
        if(CollectionUtils.isNotEmpty(stageChangeList)){
            stageChangeList.forEach(stageEntity -> {
                stageEntity.setId(null);
                stageEntity.setContractId(changeEntity.getContractId());
            });
            contractStageService.saveOrUpdateBatch(stageChangeList, stageChangeList.size(), false);
        }
        /**复制合同子表数据到记录表 end */

        //变更合同附件复制到主合同
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId),"BT200610000000003","102345678",String.valueOf(contractEntity.getId()),"BT200529000000001","subContractBill");
        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }

}
