package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {

    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private ISettleService settleService;

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO) {
        if (StringUtils.isEmpty(contractVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        //删除之前的detailList的数据
//        if (contractVO != null) {
//            Long id = contractVO.getId();
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("contract_id", new Parameter(QueryParam.IN, id));
//            List<ContractDetailEntity> contractDetailEntities = contractDetailService.queryList(queryParam);
//            if (CollectionUtils.isNotEmpty(contractDetailEntities)) {
//                contractDetailService.removeByIds(contractDetailEntities.stream().map(ContractDetailEntity::getId).collect(Collectors.toList()),false);
//            }
//        }
        ContractEntity contractEntity = BeanMapper.map(contractVO, ContractEntity.class);
        contractEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        super.saveOrUpdate(contractEntity, false);
        List<ContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            contractDetailService.saveOrUpdateBatch(contractDetailEntityList, contractDetailEntityList.size(), false);
        }
        return queryDetail(contractEntity.getId(), true);
    }

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
        ContractEntity contractEntity = super.selectById(id);
        ContractVO contractVO = BeanMapper.map(contractEntity, ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<ContractDetailEntity> detailEntityListDb = contractDetailService.queryList(queryParam, false);
        List<ContractDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (ContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<ContractDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            if (detailHasChildren) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, ContractDetailVO.class));
        }

        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage<ContractEntity> page = queryPage(param, false);
        List<ContractVO> contractVOList = BeanMapper.mapList(page.getRecords(), ContractVO.class);
        IPage<ContractVO> contractVOIPage = new Page<>();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    @Override
    public ContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<ContractDetailVO> refContractDetail(Long contractId, String condition) {
        // 树形根据code和name过滤子项
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, String> conditionMap = JSONObject.parseObject(condition, Map.class);
            String codeStr = conditionMap.get("code");
            String nameStr = conditionMap.get("name");
            code = StringUtils.isNotBlank(codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank(nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        //根据code和name过滤出来的叶子节点
        HashMap<Long, ContractDetailEntity> leafMap = new HashMap<>();
        QueryWrapper<ContractDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.orderBy(true, true, "tree_index");
        List<ContractDetailEntity> detailEntityListDb = contractDetailService.list(wrapper);
        List<ContractDetailEntity> entities = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            for (ContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag()) {
                    if (code != null && StringUtils.isNotEmpty(entity.getCode()) && !entity.getCode().contains(code))
                        continue;
                    if (name != null && StringUtils.isNotEmpty(entity.getName()) && !entity.getName().contains(name))
                        continue;
                }
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    entities.add(entity);
                    if (entity.getLeafFlag()) {
                        leafMap.put(entity.getId(), entity);
                    }
                }
            }
        }
        List<ContractDetailEntity> resList = null;
        //如果带有搜索，递归找叶子节点的父级
        if (filterFlag) {
            resList = handleFilterData(entities, leafMap);
        } else {
            resList = entities;
        }
        List<ContractDetailVO> detailVos = BeanMapper.mapList(resList, ContractDetailVO.class);
        if (CollectionUtils.isNotEmpty(detailVos)) {
            for (ContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
            }
        }
        settleService.getSumSettleNum(detailVos);
        return TreeNodeBUtil.buildTree(detailVos);
    }

    private List<ContractDetailEntity> handleFilterData(List<ContractDetailEntity> entities, HashMap<Long, ContractDetailEntity> leafMap) {

        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, ContractDetailEntity> map = entities.stream().collect(Collectors.toMap(ContractDetailEntity::getId, Function.identity()));
        ArrayList<ContractDetailEntity> resList = new ArrayList<>();
        for (Long id : leafMap.keySet()) {
            ContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(ContractDetailEntity leafContractDetailEntity, Map<Long, ContractDetailEntity> map, List<ContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if(null != parentId){
            resList.add(map.get(parentId));
            getContractDetaiParent(map.get(parentId), map , resList);
        }

    }


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ContractDetailVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ContractDetailVO vo = new ContractDetailVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setTreeIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "清单编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setUnit(datas.get(3));//计量单位

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setNum(null);
                        warnType = warnType + "工程量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }

                    // 修改由合价计算综合单价
                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setPrice(null);
                        warnType = warnType + "综合单价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价只能为数字或小数,";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setMoney(null);
                        warnType = warnType + "合价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setMoney(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setMoney(null);
                            warnType = warnType + "合价只能为数字或小数,";
                            flag = true;
                        }
                    }

                   /* if (null == vo.getNum() || null == vo.getMoney()) {
                        vo.setPrice(null);
                    } else {
                        vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()));
                        //vo.setPrice(vo.getMoney().divide(vo.getNum(), 20 ,BigDecimal.ROUND_HALF_EVEN));
                    }*/

                    if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                        vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()));
                    }

                    if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                        vo.setMoney(BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()));
                    }

                    // end

                    vo.setMemo(datas.get(7));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (ContractDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return baseMapper.subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, projectId);
        lambda.eq(ContractEntity::getDr, 0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List<ContractEntity> entities = super.list(lambda);
        for (ContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = baseMapper.getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(entities.size());
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return baseMapper.getSubSettleNum(projectIds);
    }
}
