package com.ejianc.business.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.api.IMaterialPickRegisterApi;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.FinishPickDeductVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.business.voucher.callable.VoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包零星用工表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("finish")
public class FinishBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFinishService finishService;

    @Autowired
    private IOddjobService oddjobService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMaterialPickRegisterApi materialPickRegisterApi;

    @Autowired
    private HttpServletRequest request;

    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.TRUE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.add(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.TRUE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.TRUE);
        }
        FinishEntity entity = BeanMapper.map(finishEntity, FinishEntity.class);
        finishService.costPush(entity);
        List<FinishPickDeductVO> finishPickDeductList = finishEntity.getFinishPickDeductList();
        if (CollectionUtils.isNotEmpty(finishPickDeductList)){
            List<FinishPickDeductVO> updatePickRegisterList = finishPickDeductList.stream().filter(s -> s.getRegisterId() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(updatePickRegisterList)){
                List<PickRegisterDetailVO> pickRegisterDetaiList = new ArrayList<>();
                for (FinishPickDeductVO finishPickDeductVO : updatePickRegisterList) {
                    PickRegisterDetailVO pickRegisterDetailVO = new PickRegisterDetailVO();
                    pickRegisterDetailVO.setId(finishPickDeductVO.getRegisterDetailId());
                    pickRegisterDetailVO.setRegisterId(finishPickDeductVO.getRegisterId());
                    pickRegisterDetailVO.setDeductMny(finishPickDeductVO.getDeductMny());
                    pickRegisterDetaiList.add(pickRegisterDetailVO);
                }
                logger.info("入参："+ JSONObject.toJSONString(pickRegisterDetaiList));
                if (CollectionUtils.isNotEmpty(pickRegisterDetaiList)){
                    CommonResponse<String> commonResponse =
                            materialPickRegisterApi.updateDeductMny(pickRegisterDetaiList);
                    logger.info("返回结果："+ JSONObject.toJSONString(commonResponse.isSuccess()));
                }
            }
        }

        // 推送凭证
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Long projectId = entity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    Callable<CommonResponse> voucherCallable = new VoucherCallable(finishService, VoucherOptFlag.SAVE, entity, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(voucherCallable);
                } catch (Exception e) {
                    logger.error(this.getClass() + "推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }
            }
        }
        return CommonResponse.success("审批回调合同成功！");
    }


    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.FALSE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.subtract(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.FALSE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.FALSE);
        }

        finishService.pullCost(billId);
        List<FinishPickDeductVO> finishPickDeductList = finishEntity.getFinishPickDeductList();
        if (CollectionUtils.isNotEmpty(finishPickDeductList)){
            List<FinishPickDeductVO> updatePickRegisterList = finishPickDeductList.stream().filter(s -> s.getRegisterId() != null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(updatePickRegisterList)){
                List<PickRegisterDetailVO> pickRegisterDetaiList = new ArrayList<>();
                for (FinishPickDeductVO finishPickDeductVO : updatePickRegisterList) {
                    PickRegisterDetailVO pickRegisterDetailVO = new PickRegisterDetailVO();
                    pickRegisterDetailVO.setId(finishPickDeductVO.getRegisterDetailId());
                    pickRegisterDetailVO.setRegisterId(finishPickDeductVO.getRegisterId());
                    pickRegisterDetailVO.setDeductMny(ComputeUtil.safeSub(BigDecimal.ZERO,finishPickDeductVO.getDeductMny()));
                    pickRegisterDetaiList.add(pickRegisterDetailVO);
                }
                logger.info("入参："+ JSONObject.toJSONString(pickRegisterDetaiList));
                if (CollectionUtils.isNotEmpty(pickRegisterDetaiList)){
                    CommonResponse<String> commonResponse =
                            materialPickRegisterApi.updateDeductMny(pickRegisterDetaiList);
                    logger.info("返回结果："+ JSONObject.toJSONString(commonResponse.isSuccess()));
                }
            }
        }

        FinishEntity entity = BeanMapper.map(finishEntity, FinishEntity.class);
        //更新凭证恢复到初始态
        if (!VoucherFlag.NO_NEED.equals(entity.getVoucherFlag())) {
            //有凭证则删除
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = request.getHeader("authority");
            if (authority == null) {
                logger.info("request-authority为空");
                authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
            }
            try {
                Callable<CommonResponse> voucherCallable = new VoucherCallable(finishService, VoucherOptFlag.DEL, entity, RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(voucherCallable);
            } catch (Exception e) {
                logger.error(this.getClass() + "撤回凭证异常, ", e);
            } finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

}
