package com.ejianc.business.supbid.notice.vo;

import com.ejianc.business.supbid.material.vo.DetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报价数据实体
 * 
 * @author sunyj
 * 
 */
@ApiModel("报价数据实体")
public class BjNoticeVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源租户ID")
    private String sourceTenantId;
    @ApiModelProperty("来源ID-招标主键")
    private String sourceId;
    @ApiModelProperty("当前租户主键")
    private Long tenantId;
    @ApiModelProperty("供应商主键")
    private String sourceSupplierId;
    @ApiModelProperty("联系人")
    private Long employeeId;
    @ApiModelProperty("联系人名称")
    private String employeeName;
    @ApiModelProperty("联系人电话")
    private String employeeMobile;
    @ApiModelProperty("发票说明")
    private String invoiceNote;
    @ApiModelProperty("报价操作人")
    private Long schemeId;
    @ApiModelProperty("报价操作人名称")
    private String schemeName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date schemeTime;

    @ApiModelProperty("清单明细实体")
    private List<DetailVO> detailList = new ArrayList<>();

    @ApiModelProperty("方案实体")
    private List<SchemeVO> schemeList = new ArrayList<>();

    public Date getSchemeTime() {
        return schemeTime;
    }

    public void setSchemeTime(Date schemeTime) {
        this.schemeTime = schemeTime;
    }

    public String getSourceTenantId() {
        return sourceTenantId;
    }

    public void setSourceTenantId(String sourceTenantId) {
        this.sourceTenantId = sourceTenantId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public String getInvoiceNote() {
        return invoiceNote;
    }

    public void setInvoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
    }

    public Long getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public List<DetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<SchemeVO> getSchemeList() {
        return schemeList;
    }

    public void setSchemeList(List<SchemeVO> schemeList) {
        this.schemeList = schemeList;
    }
}
