package com.ejianc.business.supbid.win.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbid.win.vo.WinDetailVO;

/**
 * 中标公告
 * 
 * @author generator
 * 
 */
@ApiModel("中标公告")
public class WinVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("系统标识")
    private String sourceType;
    @ApiModelProperty("来源id")
    private String sourceId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("发布项目ID")
    private String sourceProjectId;
    @ApiModelProperty("发布项目名称")
    private String projectName;
    @ApiModelProperty("发布项目编号")
    private String projectCode;
    @ApiModelProperty("发布组织ID")
    private String sourceOrgId;
    @ApiModelProperty("发布组织名称")
    private String orgName;
    @ApiModelProperty("招标单位ID")
    private String sourceUnitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("类型（材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER）")
    private String type;
    @ApiModelProperty("类型名称（材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER）")
    private String typeName;
    @ApiModelProperty("招标名称")
    private String tenderName;
    @ApiModelProperty("招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)")
    private Integer tenderType;
    @ApiModelProperty("招标联系人")
    private String sourceEmployeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("项目联系人")
    private String projectLinkName;
    @ApiModelProperty("项目联系人电话")
    private String projectLinkPhone;
    @ApiModelProperty("采购类别")
    private String purchaseName;
    @ApiModelProperty("流/废标（0-正常，1-流标，2-废标)")
    private Integer abolishType;
    @ApiModelProperty("中标时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winDate;
    @ApiModelProperty("中标标题")
    private String winTitle;
    @ApiModelProperty("systemId")
    private String systemId;
    
    @ApiModelProperty("中标公告明细")
    private List<WinDetailVO> winDetailList = new ArrayList<>();

    /**
     * 系统标识
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 系统标识
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源id
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布项目ID
     */
    public String getSourceProjectId() {
        return sourceProjectId;
    }

    /**
     * 发布项目ID
     */
    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    /**
     * 发布项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 发布项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发布项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 发布项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 发布组织ID
     */
    public String getSourceOrgId() {
        return sourceOrgId;
    }

    /**
     * 发布组织ID
     */
    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    /**
     * 发布组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 发布组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 招标单位ID
     */
    public String getSourceUnitId() {
        return sourceUnitId;
    }

    /**
     * 招标单位ID
     */
    public void setSourceUnitId(String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public String getType() {
        return type;
    }

    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public void setType(String type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标联系人
     */
    public String getSourceEmployeeId() {
        return sourceEmployeeId;
    }

    /**
     * 招标联系人
     */
    public void setSourceEmployeeId(String sourceEmployeeId) {
        this.sourceEmployeeId = sourceEmployeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 采购类别
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购类别
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    /**
     * 流/废标（0-正常，1-流标，2-废标)
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    /**
     * 流/废标（0-正常，1-流标，2-废标)
     */
    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }
    /**
     * 中标时间
     */
    public Date getWinDate() {
        return winDate;
    }

    /**
     * 中标时间
     */
    public void setWinDate(Date winDate) {
        this.winDate = winDate;
    }
    /**
     * 中标标题
     */
    public String getWinTitle() {
        return winTitle;
    }

    /**
     * 中标标题
     */
    public void setWinTitle(String winTitle) {
        this.winTitle = winTitle;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    /**
      * 中标公告明细
      */
      public List<WinDetailVO> getWinDetailList() {
         return winDetailList;
      }
     /**
      * 中标公告明细
      */
     public void setWinDetailList(List<WinDetailVO> winDetailList) {
         this.winDetailList = winDetailList;
     }
}
