package com.ejianc.business.supbid.other.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 其他报价明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁报价明细")
public class OtherSchemeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案主键")
    private Long schemeId;
    @ApiModelProperty("材料ID")
    private String sourceMaterialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private String sourceMaterialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供货品牌")
    private String supplierBrand;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal priceTax;
    @ApiModelProperty("总额")
    private BigDecimal money;
    @ApiModelProperty("总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String supplierMemo;
    @ApiModelProperty("计划进场时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;
    @ApiModelProperty("计划出厂时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planLeaveDate;
    @ApiModelProperty("计划天数")
    private Long planDay;

    @ApiModelProperty("收货地址")
    private String address;
    @ApiModelProperty("招标采购清单ID")
    private String sourceDetailId;
    

    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 材料ID
     */
    public String getSourceMaterialId() {
        return sourceMaterialId;
    }

    /**
     * 材料ID
     */
    public void setSourceMaterialId(String sourceMaterialId) {
        this.sourceMaterialId = sourceMaterialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public String getSourceMaterialTypeId() {
        return sourceMaterialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setSourceMaterialTypeId(String sourceMaterialTypeId) {
        this.sourceMaterialTypeId = sourceMaterialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供货品牌
     */
    public String getSupplierBrand() {
        return supplierBrand;
    }

    /**
     * 供货品牌
     */
    public void setSupplierBrand(String supplierBrand) {
        this.supplierBrand = supplierBrand;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getSupplierMemo() {
        return supplierMemo;
    }

    /**
     * 备注
     */
    public void setSupplierMemo(String supplierMemo) {
        this.supplierMemo = supplierMemo;
    }


    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public Long getPlanDay() {
        return planDay;
    }

    public void setPlanDay(Long planDay) {
        this.planDay = planDay;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(String sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
}
