package com.ejianc.business.supbid.win.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 中标通知书表
 * 
 * @author generator
 * 
 */
@ApiModel("中标通知书表")
public class BidVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("系统标识")
    private String sourceType;
    @ApiModelProperty("来源id")
    private String sourceId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("发布项目ID")
    private String sourceProjectId;
    @ApiModelProperty("发布项目名称")
    private String projectName;
    @ApiModelProperty("发布项目编号")
    private String projectCode;
    @ApiModelProperty("发布组织ID")
    private String sourceOrgId;
    @ApiModelProperty("发布组织名称")
    private String orgName;
    @ApiModelProperty("招标单位ID")
    private String sourceUnitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("类型(材料-MATERIAL,分包-SUB，设备采购-PURCHASE,设备租赁-RENT,周转材租赁-RMAT,其他-OTHER)")
    private String type;
    @ApiModelProperty("招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)")
    private Integer tenderType;
    @ApiModelProperty("中标通知书通知时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidDate;
    @ApiModelProperty("中标通知书标题")
    private String bidTitle;
    @ApiModelProperty("")
    private String systemId;
    @ApiModelProperty("中标总额（列表展示）")
    private BigDecimal money;
    @ApiModelProperty("中标总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("中标通知书文件ID")
    private Long bidFileId;

    private String typeName;

    /**
     * 系统标识
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 系统标识
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源id
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布项目ID
     */
    public String getSourceProjectId() {
        return sourceProjectId;
    }

    /**
     * 发布项目ID
     */
    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    /**
     * 发布项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 发布项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发布项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 发布项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 发布组织ID
     */
    public String getSourceOrgId() {
        return sourceOrgId;
    }

    /**
     * 发布组织ID
     */
    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    /**
     * 发布组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 发布组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 招标单位ID
     */
    public String getSourceUnitId() {
        return sourceUnitId;
    }

    /**
     * 招标单位ID
     */
    public void setSourceUnitId(String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public String getType() {
        return type;
    }

    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    /**
     * 中标通知书通知时间
     */
    public Date getBidDate() {
        return bidDate;
    }

    /**
     * 中标通知书通知时间
     */
    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    /**
     * 中标通知书标题
     */
    public String getBidTitle() {
        return bidTitle;
    }

    /**
     * 中标通知书标题
     */
    public void setBidTitle(String bidTitle) {
        this.bidTitle = bidTitle;
    }
    /**
     * 
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * 
     */
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }


    /**
     * 中标总额（列表展示）
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 中标总额（列表展示）
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 中标总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 中标总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    /**
     * 中标通知书文件ID
     */
    public Long getBidFileId() {
        return bidFileId;
    }

    /**
     * 中标通知书文件ID
     */
    public void setBidFileId(Long bidFileId) {
        this.bidFileId = bidFileId;
    }


    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}
