package com.ejianc.business.supbid.notice.vo;

import com.ejianc.business.supbid.material.vo.DetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.other.vo.OtherDetailVO;
import com.ejianc.business.supbid.other.vo.OtherSchemeVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseDetailVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeVO;
import com.ejianc.business.supbid.rent.vo.RentDetailVO;
import com.ejianc.business.supbid.rent.vo.RentSchemeVO;
import com.ejianc.business.supbid.rmat.vo.RmatDetailVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeVO;
import com.ejianc.business.supbid.sub.vo.SubDetailVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报价数据实体
 * 
 * @author sunyj
 * 
 */
@ApiModel("报价数据实体")
public class BjNoticeVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源ID-招标主键")
    private String sourceId;
    @ApiModelProperty("当前租户主键")
    private Long tenantId;
    @ApiModelProperty("供应商主键")
    private String sourceSupplierId;
    @ApiModelProperty("联系人")
    private Long employeeId;
    @ApiModelProperty("联系人名称")
    private String employeeName;
    @ApiModelProperty("联系人电话")
    private String employeeMobile;
    @ApiModelProperty("发票说明")
    private String invoiceNote;
    @ApiModelProperty("报价操作人")
    private Long schemeId;
    @ApiModelProperty("报价操作人名称")
    private String schemeName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date schemeTime;

    @ApiModelProperty("清单明细实体")
    private List<DetailVO> detailList = new ArrayList<>();
    @ApiModelProperty("分包清单明细实体")
    private List<SubDetailVO> subDetailList = new ArrayList<>();
    @ApiModelProperty("设备采购清单明细实体")
    private List<PurchaseDetailVO> purchaseDetailList = new ArrayList<>();
    @ApiModelProperty("设备租赁清单明细实体")
    private List<RentDetailVO> rentDetailList = new ArrayList<>();
    @ApiModelProperty("周转材租赁清单明细实体")
    private List<RmatDetailVO> rmatDetailList = new ArrayList<>();
    @ApiModelProperty("其他清单明细实体")
    private List<OtherDetailVO> otherDetailList = new ArrayList<>();

    @ApiModelProperty("方案实体")
    private List<SchemeVO> schemeList = new ArrayList<>();
    @ApiModelProperty("分包方案实体")
    private List<SubSchemeVO> subSchemeList = new ArrayList<>();
    @ApiModelProperty("设备采购方案实体")
    private List<PurchaseSchemeVO> purchaseSchemeList = new ArrayList<>();
    @ApiModelProperty("设备租赁方案实体")
    private List<RentSchemeVO> rentSchemeList = new ArrayList<>();
    @ApiModelProperty("周转材租赁方案实体")
    private List<RmatSchemeVO> rmatSchemeList = new ArrayList<>();
    @ApiModelProperty("其他方案实体")
    private List<OtherSchemeVO> otherSchemeList = new ArrayList<>();

    public Date getSchemeTime() {
        return schemeTime;
    }

    public void setSchemeTime(Date schemeTime) {
        this.schemeTime = schemeTime;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public String getInvoiceNote() {
        return invoiceNote;
    }

    public void setInvoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
    }

    public Long getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public List<DetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<SchemeVO> getSchemeList() {
        return schemeList;
    }

    public void setSchemeList(List<SchemeVO> schemeList) {
        this.schemeList = schemeList;
    }

    public List<SubSchemeVO> getSubSchemeList() {
        return subSchemeList;
    }

    public void setSubSchemeList(List<SubSchemeVO> subSchemeList) {
        this.subSchemeList = subSchemeList;
    }

    public List<SubDetailVO> getSubDetailList() {
        return subDetailList;
    }

    public void setSubDetailList(List<SubDetailVO> subDetailList) {
        this.subDetailList = subDetailList;
    }

    public List<PurchaseDetailVO> getPurchaseDetailList() {
        return purchaseDetailList;
    }

    public void setPurchaseDetailList(List<PurchaseDetailVO> purchaseDetailList) {
        this.purchaseDetailList = purchaseDetailList;
    }

    public List<PurchaseSchemeVO> getPurchaseSchemeList() {
        return purchaseSchemeList;
    }

    public void setPurchaseSchemeList(List<PurchaseSchemeVO> purchaseSchemeList) {
        this.purchaseSchemeList = purchaseSchemeList;
    }

    public List<RentDetailVO> getRentDetailList() {
        return rentDetailList;
    }

    public void setRentDetailList(List<RentDetailVO> rentDetailList) {
        this.rentDetailList = rentDetailList;
    }

    public List<RentSchemeVO> getRentSchemeList() {
        return rentSchemeList;
    }

    public void setRentSchemeList(List<RentSchemeVO> rentSchemeList) {
        this.rentSchemeList = rentSchemeList;
    }

    public List<RmatDetailVO> getRmatDetailList() {
        return rmatDetailList;
    }

    public void setRmatDetailList(List<RmatDetailVO> rmatDetailList) {
        this.rmatDetailList = rmatDetailList;
    }

    public List<RmatSchemeVO> getRmatSchemeList() {
        return rmatSchemeList;
    }

    public void setRmatSchemeList(List<RmatSchemeVO> rmatSchemeList) {
        this.rmatSchemeList = rmatSchemeList;
    }

    public List<OtherDetailVO> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<OtherDetailVO> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }

    public List<OtherSchemeVO> getOtherSchemeList() {
        return otherSchemeList;
    }

    public void setOtherSchemeList(List<OtherSchemeVO> otherSchemeList) {
        this.otherSchemeList = otherSchemeList;
    }
}
