package com.ejianc.business.supbid.notice.vo;

import com.ejianc.business.supbid.material.vo.DetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报名数据实体
 * 
 * @author sunyj
 * 
 */
@ApiModel("报名数据实体")
public class BmNoticeVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源租户ID")
    private String sourceTenantId;
    @ApiModelProperty("来源ID-招标主键")
    private String sourceId;
    @ApiModelProperty("当前租户主键")
    private Long tenantId;
    @ApiModelProperty("供应商主键")
    private String SourceSupplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("报名联系人")
    private Long employeeId;
    @ApiModelProperty("报名联系人名称")
    private String employeeName;
    @ApiModelProperty("报名联系人电话")
    private String employeeMobile;
    @ApiModelProperty("报名时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date signTime;
    @ApiModelProperty("报名操作人")
    private java.lang.Long signId;
    @ApiModelProperty("报名操作人名称")
    private java.lang.String signName;

    @ApiModelProperty("附件")
    private InputStream inputStream;
    @ApiModelProperty("附件名称")
    private String fileName;

    // 20220801 修改，不传文件流，传文件全路径
    @ApiModelProperty("附件全路径")
    private List<SupplyFileVo> supplyFileList;

    public List<SupplyFileVo> getSupplyFileList() {
        return supplyFileList;
    }

    public void setSupplyFileList(List<SupplyFileVo> supplyFileList) {
        this.supplyFileList = supplyFileList;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSourceTenantId() {
        return sourceTenantId;
    }

    public void setSourceTenantId(String sourceTenantId) {
        this.sourceTenantId = sourceTenantId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getSourceSupplierId() {
        return SourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        SourceSupplierId = sourceSupplierId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }

    public Long getSignId() {
        return signId;
    }

    public void setSignId(Long signId) {
        this.signId = signId;
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }
}
