package com.ejianc.business.supbid.sub.vo;

import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 分包洽商谈判方案记录表
 * 
 * @author generator
 * 
 */
@ApiModel("分包洽商谈判方案记录表")
public class SubSchemeRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private Long noticeId;
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案名称")
    private String schemeName;
    @ApiModelProperty("报价总额")
    private BigDecimal mny;
    @ApiModelProperty("报价总额(含税)")
    private BigDecimal taxMny;
    @ApiModelProperty("轮数")
    private Integer talkNum;

    private List<SubSchemeDetailRecordVO> subSchemeDetailList = new ArrayList<>(); // 报价明细实体记录表


    public List<SubSchemeDetailRecordVO> getSubSchemeDetailList() {
        return subSchemeDetailList;
    }

    public void setSubSchemeDetailList(List<SubSchemeDetailRecordVO> subSchemeDetailList) {
        this.subSchemeDetailList = subSchemeDetailList;
    }

    /**
     * 主表主键
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 主表主键
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案名称
     */
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * 方案名称
     */
    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 轮数
     */
    public Integer getTalkNum() {
        return talkNum;
    }

    /**
     * 轮数
     */
    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    
}
