package com.ejianc.business.supbid.notice.vo;

import com.ejianc.business.supbid.material.vo.DetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.business.supbid.other.vo.OtherDetailVO;
import com.ejianc.business.supbid.other.vo.OtherSchemeVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseDetailVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeVO;
import com.ejianc.business.supbid.rent.vo.RentDetailVO;
import com.ejianc.business.supbid.rent.vo.RentSchemeVO;
import com.ejianc.business.supbid.rmat.vo.RmatDetailVO;
import com.ejianc.business.supbid.rmat.vo.RmatSchemeVO;
import com.ejianc.business.supbid.sub.vo.SubDetailVO;
import com.ejianc.business.supbid.sub.vo.SubSchemeVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报价数据实体
 * 
 * @author sunyj
 * 
 */
@ApiModel("报价数据实体")
public class BjNoticeVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源ID-招标主键")
    private String sourceId;
    @ApiModelProperty("当前租户主键")
    private Long tenantId;
    @ApiModelProperty("供应商主键")
    private String sourceSupplierId;
    @ApiModelProperty("联系人")
    private Long employeeId;
    @ApiModelProperty("联系人名称")
    private String employeeName;
    @ApiModelProperty("联系人电话")
    private String employeeMobile;
    @ApiModelProperty("发票说明")
    private String invoiceNote;
    @ApiModelProperty("报价操作人")
    private Long schemeId;
    @ApiModelProperty("报价操作人名称")
    private String schemeName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date schemeTime;
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）
    private BigDecimal mnySubTender; //投标总价（无税）
    private java.lang.String mnySubTenderName; // 投标总价（无税）大写
    private BigDecimal taxMnySubTender; // 投标总价
    private java.lang.String taxMnySubTenderName; // 投标总价大写

    private java.lang.String priceType; // 新增单价确定方式
    private java.lang.String qualityPromise; // 质量承诺
    private java.lang.String safePromise; // 安全文明施工承诺
    private java.lang.String durationPromise; // 工期承诺
    private java.lang.String marginType; // 投标保证金形式
    private java.lang.String otherPromise; //其他承诺

    private java.lang.Integer tenderType; // 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)

    @ApiModelProperty("清单明细实体")
    private List<DetailVO> detailList = new ArrayList<>();
    @ApiModelProperty("分包清单明细实体")
    private List<SubDetailVO> subDetailList = new ArrayList<>();
    @ApiModelProperty("设备采购清单明细实体")
    private List<PurchaseDetailVO> purchaseDetailList = new ArrayList<>();
    @ApiModelProperty("设备租赁清单明细实体")
    private List<RentDetailVO> rentDetailList = new ArrayList<>();
    @ApiModelProperty("周转材租赁清单明细实体")
    private List<RmatDetailVO> rmatDetailList = new ArrayList<>();
    @ApiModelProperty("其他清单明细实体")
    private List<OtherDetailVO> otherDetailList = new ArrayList<>();

    @ApiModelProperty("方案实体")
    private List<SchemeVO> schemeList = new ArrayList<>();
    @ApiModelProperty("分包方案实体")
    private List<SubSchemeVO> subSchemeList = new ArrayList<>();
    @ApiModelProperty("设备采购方案实体")
    private List<PurchaseSchemeVO> purchaseSchemeList = new ArrayList<>();
    @ApiModelProperty("设备租赁方案实体")
    private List<RentSchemeVO> rentSchemeList = new ArrayList<>();
    @ApiModelProperty("周转材租赁方案实体")
    private List<RmatSchemeVO> rmatSchemeList = new ArrayList<>();
    @ApiModelProperty("其他方案实体")
    private List<OtherSchemeVO> otherSchemeList = new ArrayList<>();

    // 20220801 修改，不传文件流，传文件全路径
    @ApiModelProperty("附件全路径")
    private List<SupplyFileVo> supplyFileList;

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public BigDecimal getMnySubTender() {
        return mnySubTender;
    }

    public void setMnySubTender(BigDecimal mnySubTender) {
        this.mnySubTender = mnySubTender;
    }

    public String getMnySubTenderName() {
        return mnySubTenderName;
    }

    public void setMnySubTenderName(String mnySubTenderName) {
        this.mnySubTenderName = mnySubTenderName;
    }

    public BigDecimal getTaxMnySubTender() {
        return taxMnySubTender;
    }

    public void setTaxMnySubTender(BigDecimal taxMnySubTender) {
        this.taxMnySubTender = taxMnySubTender;
    }

    public String getTaxMnySubTenderName() {
        return taxMnySubTenderName;
    }

    public void setTaxMnySubTenderName(String taxMnySubTenderName) {
        this.taxMnySubTenderName = taxMnySubTenderName;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public String getQualityPromise() {
        return qualityPromise;
    }

    public void setQualityPromise(String qualityPromise) {
        this.qualityPromise = qualityPromise;
    }

    public String getSafePromise() {
        return safePromise;
    }

    public void setSafePromise(String safePromise) {
        this.safePromise = safePromise;
    }

    public String getDurationPromise() {
        return durationPromise;
    }

    public void setDurationPromise(String durationPromise) {
        this.durationPromise = durationPromise;
    }

    public String getMarginType() {
        return marginType;
    }

    public void setMarginType(String marginType) {
        this.marginType = marginType;
    }

    public String getOtherPromise() {
        return otherPromise;
    }

    public void setOtherPromise(String otherPromise) {
        this.otherPromise = otherPromise;
    }

    private Long equipmentType; // 设备类型（0-机械设备租赁，1-机械承揽）

    public Long getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Long equipmentType) {
        this.equipmentType = equipmentType;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public List<SupplyFileVo> getSupplyFileList() {
        return supplyFileList;
    }

    public void setSupplyFileList(List<SupplyFileVo> supplyFileList) {
        this.supplyFileList = supplyFileList;
    }

    public Date getSchemeTime() {
        return schemeTime;
    }

    public void setSchemeTime(Date schemeTime) {
        this.schemeTime = schemeTime;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public String getInvoiceNote() {
        return invoiceNote;
    }

    public void setInvoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
    }

    public Long getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public List<DetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<SchemeVO> getSchemeList() {
        return schemeList;
    }

    public void setSchemeList(List<SchemeVO> schemeList) {
        this.schemeList = schemeList;
    }

    public List<SubSchemeVO> getSubSchemeList() {
        return subSchemeList;
    }

    public void setSubSchemeList(List<SubSchemeVO> subSchemeList) {
        this.subSchemeList = subSchemeList;
    }

    public List<SubDetailVO> getSubDetailList() {
        return subDetailList;
    }

    public void setSubDetailList(List<SubDetailVO> subDetailList) {
        this.subDetailList = subDetailList;
    }

    public List<PurchaseDetailVO> getPurchaseDetailList() {
        return purchaseDetailList;
    }

    public void setPurchaseDetailList(List<PurchaseDetailVO> purchaseDetailList) {
        this.purchaseDetailList = purchaseDetailList;
    }

    public List<PurchaseSchemeVO> getPurchaseSchemeList() {
        return purchaseSchemeList;
    }

    public void setPurchaseSchemeList(List<PurchaseSchemeVO> purchaseSchemeList) {
        this.purchaseSchemeList = purchaseSchemeList;
    }

    public List<RentDetailVO> getRentDetailList() {
        return rentDetailList;
    }

    public void setRentDetailList(List<RentDetailVO> rentDetailList) {
        this.rentDetailList = rentDetailList;
    }

    public List<RentSchemeVO> getRentSchemeList() {
        return rentSchemeList;
    }

    public void setRentSchemeList(List<RentSchemeVO> rentSchemeList) {
        this.rentSchemeList = rentSchemeList;
    }

    public List<RmatDetailVO> getRmatDetailList() {
        return rmatDetailList;
    }

    public void setRmatDetailList(List<RmatDetailVO> rmatDetailList) {
        this.rmatDetailList = rmatDetailList;
    }

    public List<RmatSchemeVO> getRmatSchemeList() {
        return rmatSchemeList;
    }

    public void setRmatSchemeList(List<RmatSchemeVO> rmatSchemeList) {
        this.rmatSchemeList = rmatSchemeList;
    }

    public List<OtherDetailVO> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<OtherDetailVO> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }

    public List<OtherSchemeVO> getOtherSchemeList() {
        return otherSchemeList;
    }

    public void setOtherSchemeList(List<OtherSchemeVO> otherSchemeList) {
        this.otherSchemeList = otherSchemeList;
    }
}
