package com.ejianc.business.supbid.purchase.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeDetailVO;
import com.ejianc.business.supbid.purchase.vo.PurchaseSchemeRecordVO;

/**
 * 设备采购方案实体
 * 
 * @author generator
 * 
 */
@ApiModel("设备采购方案实体")
public class PurchaseSchemeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private Long noticeId;
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案名称")
    private String schemeName;
    @ApiModelProperty("报价总额")
    private BigDecimal money;
    @ApiModelProperty("报价总额(含税)")
    private BigDecimal moneyTax;
    
    @ApiModelProperty("设备采购报价明细")
    private List<PurchaseSchemeDetailVO> purchaseSchemeDetailList = new ArrayList<>();

    /**
     * 主表主键
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 主表主键
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案名称
     */
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * 方案名称
     */
    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    /**
     * 报价总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 报价总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 报价总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 报价总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    
     /**
      * 设备采购报价明细
      */
      public List<PurchaseSchemeDetailVO> getPurchaseSchemeDetailList() {
         return purchaseSchemeDetailList;
      }
     /**
      * 设备采购报价明细
      */
     public void setPurchaseSchemeDetailList(List<PurchaseSchemeDetailVO> purchaseSchemeDetailList) {
         this.purchaseSchemeDetailList = purchaseSchemeDetailList;
     }
}
