package com.ejianc.business.supbid.sub.vo;

import java.math.*;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 分包洽商谈判方案明细记录表
 * 
 * @author generator
 * 
 */
@ApiModel("分包洽商谈判方案明细记录表")
public class SubSchemeDetailRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案主键")
    private Long schemeId;
    @ApiModelProperty("招标采购清单ID")
    private String sourceDetailId;
    @ApiModelProperty("清单编号")
    private String detailCode;
    @ApiModelProperty("清单名称")
    private String detailName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供货品牌")
    private String supplierBrand;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("总额")
    private BigDecimal mny;
    @ApiModelProperty("总额(含税)")
    private BigDecimal taxMny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String supplierMemo;

    @ApiModelProperty("明细税率（不可修改）")
    private java.math.BigDecimal detailRate;
    private String materialEquipmentSupply; // 材料设备供应

    private BigDecimal artificialTaxMny; //人工费金额
    private BigDecimal artificialMny; //人工费金额（无税）
    private BigDecimal artificialTax; //人工费税额
    private BigDecimal artificialTaxPrice; // 人工费单价
    private BigDecimal artificialPrice; // 人工费单价(无税）
    private BigDecimal artificialControlPrice; // 人工费控制单价(无税）

    public BigDecimal getArtificialControlPrice() {
        return artificialControlPrice;
    }

    public void setArtificialControlPrice(BigDecimal artificialControlPrice) {
        this.artificialControlPrice = artificialControlPrice;
    }

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public BigDecimal getArtificialMny() {
        return artificialMny;
    }

    public void setArtificialMny(BigDecimal artificialMny) {
        this.artificialMny = artificialMny;
    }

    public BigDecimal getArtificialTax() {
        return artificialTax;
    }

    public void setArtificialTax(BigDecimal artificialTax) {
        this.artificialTax = artificialTax;
    }

    public BigDecimal getArtificialTaxPrice() {
        return artificialTaxPrice;
    }

    public void setArtificialTaxPrice(BigDecimal artificialTaxPrice) {
        this.artificialTaxPrice = artificialTaxPrice;
    }

    public BigDecimal getArtificialPrice() {
        return artificialPrice;
    }

    public void setArtificialPrice(BigDecimal artificialPrice) {
        this.artificialPrice = artificialPrice;
    }

    public String getMaterialEquipmentSupply() {
        return materialEquipmentSupply;
    }

    public void setMaterialEquipmentSupply(String materialEquipmentSupply) {
        this.materialEquipmentSupply = materialEquipmentSupply;
    }
    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }

    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 招标采购清单ID
     */
    public String getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 招标采购清单ID
     */
    public void setSourceDetailId(String sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 清单编号
     */
    public String getDetailCode() {
        return detailCode;
    }

    /**
     * 清单编号
     */
    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }
    /**
     * 清单名称
     */
    public String getDetailName() {
        return detailName;
    }

    /**
     * 清单名称
     */
    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供货品牌
     */
    public String getSupplierBrand() {
        return supplierBrand;
    }

    /**
     * 供货品牌
     */
    public void setSupplierBrand(String supplierBrand) {
        this.supplierBrand = supplierBrand;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getSupplierMemo() {
        return supplierMemo;
    }

    /**
     * 备注
     */
    public void setSupplierMemo(String supplierMemo) {
        this.supplierMemo = supplierMemo;
    }
    
}
