package com.ejianc.business.supbid.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 设备租赁清单明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁清单明细")
public class RentDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主表主键")
    private Long noticeId;
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("材料ID")
    private String sourceMaterialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private String sourceMaterialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("计划进场时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;
    @ApiModelProperty("计划出厂时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planLeaveDate;
    @ApiModelProperty("计划天数")
    private BigDecimal planDay;

    private BigDecimal rentNum; // 租赁数量
    private Integer flagOil; // 是否含油 (1:是，0：否)
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    private BigDecimal priceTender; //招标控制单价（无税）
    private BigDecimal taxPriceTender; // 招标控制单价
    private BigDecimal taxTender; // 税额
    private Long billingUnitId;  //计费单位主键
    private String billingUnitName;//计费单位名称
    private String detailMeasurementRules;//计量规则
    private String jobContent;//工作内容

    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }
    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }

    public BigDecimal getPriceTender() {
        return priceTender;
    }

    public void setPriceTender(BigDecimal priceTender) {
        this.priceTender = priceTender;
    }

    public BigDecimal getTaxPriceTender() {
        return taxPriceTender;
    }

    public void setTaxPriceTender(BigDecimal taxPriceTender) {
        this.taxPriceTender = taxPriceTender;
    }

    public BigDecimal getTaxTender() {
        return taxTender;
    }

    public void setTaxTender(BigDecimal taxTender) {
        this.taxTender = taxTender;
    }

    public Long getBillingUnitId() {
        return billingUnitId;
    }

    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }

    public String getBillingUnitName() {
        return billingUnitName;
    }

    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }

    /**
     * 主表主键
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 主表主键
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 材料ID
     */
    public String getSourceMaterialId() {
        return sourceMaterialId;
    }

    /**
     * 材料ID
     */
    public void setSourceMaterialId(String sourceMaterialId) {
        this.sourceMaterialId = sourceMaterialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public String getSourceMaterialTypeId() {
        return sourceMaterialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setSourceMaterialTypeId(String sourceMaterialTypeId) {
        this.sourceMaterialTypeId = sourceMaterialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 计划进场时间
     */
    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    /**
     * 计划进场时间
     */
    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }
    /**
     * 计划出厂时间
     */
    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    /**
     * 计划出厂时间
     */
    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }
}
