package com.ejianc.business.supbid.notice.vo;

import com.ejianc.business.supbid.material.vo.DetailVO;
import com.ejianc.business.supbid.material.vo.SchemeVO;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 公告实体
 * 
 * @author generator
 * 
 */
@ApiModel("公告实体")
public class NoticeFileVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统标识")
    private String sourceType;
    @ApiModelProperty("系统标识")
    private String sourceId;
    @ApiModelProperty("来源租户ID")
    private String sourceTenantId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("发布项目ID")
    private String sourceProjectId;
    @ApiModelProperty("发布项目名称")
    private String projectName;
    @ApiModelProperty("发布项目编号")
    private String projectCode;
    @ApiModelProperty("发布组织ID")
    private String sourceOrgId;
    @ApiModelProperty("发布组织名称")
    private String orgName;
    @ApiModelProperty("招标单位ID")
    private String sourceUnitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)")
    private String type;
    @ApiModelProperty("招标名称")
    private String tenderName;
    @ApiModelProperty("招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)")
    private Integer tenderType;
    @ApiModelProperty("招标联系人")
    private String sourceEmployeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("项目联系人")
    private String projectLinkName;
    @ApiModelProperty("项目联系人电话")
    private String projectLinkPhone;
    @ApiModelProperty("报名开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date noticeStartTime;
    @ApiModelProperty("报名截止时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date noticeEndTime;
    @ApiModelProperty("报价开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerStartTime;
    @ApiModelProperty("报价结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerEndTime;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private Integer brandFlag;
    @ApiModelProperty("计价方式(0-固定单价,1-浮动单价,2-固定总额)")
    private Integer valueType;

    @ApiModelProperty("公告内容")
    private String noticeContent;

    @ApiModelProperty("文件内容")
    private String content;

    @ApiModelProperty("报名实体")
    private List<SignVO> signVos = new ArrayList<>();
    @ApiModelProperty("方案实体")
    private List<SchemeVO> schemeVos = new ArrayList<>();
    @ApiModelProperty("清单明细实体")
    private List<DetailVO> detailVos = new ArrayList<>();
    private Boolean repetitionFlag; // 是否允许二次报价，默认开启，非这两种类型意外其他类型默认关

    public Boolean getRepetitionFlag() {
        return repetitionFlag;
    }

    public void setRepetitionFlag(Boolean repetitionFlag) {
        this.repetitionFlag = repetitionFlag;
    }

    public String getNoticeContent() {
        return noticeContent;
    }

    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 系统标识
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 系统标识
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 系统标识
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 系统标识
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源租户ID
     */
    public String getSourceTenantId() {
        return sourceTenantId;
    }

    /**
     * 来源租户ID
     */
    public void setSourceTenantId(String sourceTenantId) {
        this.sourceTenantId = sourceTenantId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 发布项目ID
     */
    public String getSourceProjectId() {
        return sourceProjectId;
    }

    /**
     * 发布项目ID
     */
    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    /**
     * 发布项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 发布项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 发布项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 发布项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 发布组织ID
     */
    public String getSourceOrgId() {
        return sourceOrgId;
    }

    /**
     * 发布组织ID
     */
    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }
    /**
     * 发布组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 发布组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 招标单位ID
     */
    public String getSourceUnitId() {
        return sourceUnitId;
    }

    /**
     * 招标单位ID
     */
    public void setSourceUnitId(String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public String getType() {
        return type;
    }

    /**
     * 类型(1-材料采购招标，2-分包招标,3-设备采购招标，4-设备租赁招标，5-周转材租赁招标，6-其他招标)
     */
    public void setType(String type) {
        this.type = type;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标联系人
     */
    public String getSourceEmployeeId() {
        return sourceEmployeeId;
    }

    /**
     * 招标联系人
     */
    public void setSourceEmployeeId(String sourceEmployeeId) {
        this.sourceEmployeeId = sourceEmployeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目联系人
     */
    public String getProjectLinkName() {
        return projectLinkName;
    }

    /**
     * 项目联系人
     */
    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }
    /**
     * 项目联系人电话
     */
    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    /**
     * 项目联系人电话
     */
    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }
    /**
     * 报名开始时间
     */
    public java.util.Date getNoticeStartTime() {
        return noticeStartTime;
    }

    /**
     * 报名开始时间
     */
    public void setNoticeStartTime(java.util.Date noticeStartTime) {
        this.noticeStartTime = noticeStartTime;
    }
    /**
     * 报名截止时间
     */
    public java.util.Date getNoticeEndTime() {
        return noticeEndTime;
    }

    /**
     * 报名截止时间
     */
    public void setNoticeEndTime(java.util.Date noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }
    /**
     * 报价开始时间
     */
    public java.util.Date getOfferStartTime() {
        return offerStartTime;
    }

    /**
     * 报价开始时间
     */
    public void setOfferStartTime(java.util.Date offerStartTime) {
        this.offerStartTime = offerStartTime;
    }
    /**
     * 报价结束时间
     */
    public java.util.Date getOfferEndTime() {
        return offerEndTime;
    }

    /**
     * 报价结束时间
     */
    public void setOfferEndTime(java.util.Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    
     /**
      * 报名实体
      */
     public List<SignVO> getSignVos() {
        return signVos;
     }

     /**
      * 报名实体
      */
     public void setSignVos(List<SignVO> signVos) {
        this.signVos = signVos;
     }
     /**
      * 方案实体
      */
     public List<SchemeVO> getSchemeVos() {
        return schemeVos;
     }

     /**
      * 方案实体
      */
     public void setSchemeVos(List<SchemeVO> schemeVos) {
        this.schemeVos = schemeVos;
     }
     /**
      * 清单明细实体
      */
     public List<DetailVO> getDetailVos() {
        return detailVos;
     }

     /**
      * 清单明细实体
      */
     public void setDetailVos(List<DetailVO> detailVos) {
        this.detailVos = detailVos;
     }
}
