package com.ejianc.business.supplier.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商准入
 * 
 * @author generator
 * 
 */
public class AccessVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 供方准入编码
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Integer billType; // 1-分包，2-物资
    private String name; // 供方准入名称
    private Long enterpriseNatureId; // 企业性质id
    private String enterpriseNatureName; // 企业性质名称
    private String legal; // 法定代表人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registerTime; // 注册日期
    private String taxPayerIdentifier; // 纳税人识别号
    private Long taxPayerTypeId; // 纳税人类型id
    private String taxPayerTypeName; // 纳税人类型名称
    private java.math.BigDecimal registeredCapital; // 注册资金
    private String legalPhone; // 法人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date lssuingTime; // 发证时间
    private Long categoryId; // 供方分类id
    private String categoryName; // 供方分类名称
    private String socialCreditCode; // 统一社会信用代码
    private String address; // 详细地址
    private String businessScope; // 经营范围
    private String orgName; // 所属组织名称
    private Long orgId; // 所属组织id
    
    private List<CertificateVO> certificateList = new ArrayList<>(); // 企业证件
    private List<LinkerVO> linkerList = new ArrayList<>(); // 供应商联系人
    private List<HistoricalPerformanceVO> historicalPerformanceList = new ArrayList<>(); // 企业历史业绩
    private List<BankAccountVO> bankAccountList = new ArrayList<>(); // 供应商银行账户

    /**
     * 供方准入编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 供方准入编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 1-分包，2-物资
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包，2-物资
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    /**
     * 供方准入名称
     */
    public String getName() {
        return name;
    }

    /**
     * 供方准入名称
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * 企业性质id
     */
    public Long getEnterpriseNatureId() {
        return enterpriseNatureId;
    }

    /**
     * 企业性质id
     */
    public void setEnterpriseNatureId(Long enterpriseNatureId) {
        this.enterpriseNatureId = enterpriseNatureId;
    }
    
    /**
     * 企业性质名称
     */
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    /**
     * 企业性质名称
     */
    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    /**
     * 法定代表人
     */
    public String getLegal() {
        return legal;
    }

    /**
     * 法定代表人
     */
    public void setLegal(String legal) {
        this.legal = legal;
    }
    /**
     * 注册日期
     */
    public java.util.Date getRegisterTime() {
        return registerTime;
    }

    /**
     * 注册日期
     */
    public void setRegisterTime(java.util.Date registerTime) {
        this.registerTime = registerTime;
    }
    /**
     * 纳税人识别号
     */
    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    /**
     * 纳税人识别号
     */
    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }
    
    /**
     * 纳税人类型id
     */
    public Long getTaxPayerTypeId() {
        return taxPayerTypeId;
    }

    /**
     * 纳税人类型id
     */
    public void setTaxPayerTypeId(Long taxPayerTypeId) {
        this.taxPayerTypeId = taxPayerTypeId;
    }
    
    /**
     * 纳税人类型名称
     */
    public String getTaxPayerTypeName() {
        return taxPayerTypeName;
    }

    /**
     * 纳税人类型名称
     */
    public void setTaxPayerTypeName(String taxPayerTypeName) {
        this.taxPayerTypeName = taxPayerTypeName;
    }
    
    /**
     * 注册资金
     */
    public java.math.BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    /**
     * 注册资金
     */
    public void setRegisteredCapital(java.math.BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    /**
     * 法人电话
     */
    public String getLegalPhone() {
        return legalPhone;
    }

    /**
     * 法人电话
     */
    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }

    /**
     * 发证时间
     */
    public Date getLssuingTime() {
        return lssuingTime;
    }

    /**
     * 发证时间
     */
    public void setLssuingTime(Date lssuingTime) {
        this.lssuingTime = lssuingTime;
    }

    /**
     * 供方分类id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 供方分类id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 供方分类名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 供方分类名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 统一社会信用代码
     */
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    /**
     * 详细地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 详细地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 经营范围
     */
    public String getBusinessScope() {
        return businessScope;
    }

    /**
     * 经营范围
     */
    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 企业证件
     */
    public List<CertificateVO> getCertificateList() {
        return certificateList;
    }

    /**
     * 企业证件
     */
    public void setCertificateList(List<CertificateVO> certificateList) {
        this.certificateList = certificateList;
    }

    /**
     * 供应商联系人
     */
    public List<LinkerVO> getLinkerList() {
        return linkerList;
    }

    /**
     * 供应商联系人
     */
    public void setLinkerList(List<LinkerVO> linkerList) {
        this.linkerList = linkerList;
    }

    /**
     * 企业历史业绩
     */
    public List<HistoricalPerformanceVO> getHistoricalPerformanceList() {
        return historicalPerformanceList;
    }

    /**
     * 企业历史业绩
     */
    public void setHistoricalPerformanceList(List<HistoricalPerformanceVO> historicalPerformanceList) {
        this.historicalPerformanceList = historicalPerformanceList;
    }

    /**
     * 供应商银行账户
     */
    public List<BankAccountVO> getBankAccountList() {
        return bankAccountList;
    }

    /**
     * 供应商银行账户
     */
    public void setBankAccountList(List<BankAccountVO> bankAccountList) {
        this.bankAccountList = bankAccountList;
    }
}
