package com.ejianc.business.supplier.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.supplier.bean.SupplierYearReviewEvaluateEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商年度评价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_year_evaluate")
public class SupplierYearEvaluateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="supplier_id")
    private Long supplierId; // 供方主键
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="supplier_linkman")
    private String supplierLinkman; // 供方联系人
    @TableField(value="supplier_mobile")
    private String supplierMobile; // 供方联系电话
    @TableField(value="supplier_registered_capital")
    private java.math.BigDecimal supplierRegisteredCapital; // 注册资金
    @TableField(value="evaluation_org_id")
    private Long evaluationOrgId; // 评价单位主键
    @TableField(value="evaluation_org_name")
    private String evaluationOrgName; // 评价单位名称
    @TableField(value="evaluation_year")
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private java.util.Date evaluationYear; // 评价年度
    @TableField(value="year_evaluation_score")
    private java.math.BigDecimal yearEvaluationScore; // 年度评价得分
    @TableField(value="evaluation_grade")
    private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    @TableField(value="assessor")
    private String assessor; // 参加考评人员
    @TableField(value="supplier_category_id")
    private Long supplierCategoryId; // 供方分类主键
    @TableField(value="supplier_category_name")
    private String supplierCategoryName; // 供方分类名称
    @TableField(value="bill_type")
    private Integer billType; // 1-分包；2-物资
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="evaluation_date")
    private java.util.Date evaluationDate; // 评价时间
    
    @TableField(exist=false)
    @SubEntity(serviceName="supplierYearReviewEvaluateService",pidName = "yearEvaluateId")
    private List<SupplierYearReviewEvaluateEntity> evaluateList = new ArrayList<>(); // 供应商年度评价评审项目

    @TableField(exist=false)
    @SubEntity(serviceName="supplierYearCourseEvaluateService",pidName = "yearEvaluateId")
    private List<SupplierYearCourseEvaluateEntity> courseList = new ArrayList<>(); //

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供方主键
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供方联系人
     */
    public String getSupplierLinkman() {
        return supplierLinkman;
    }

    /**
     * 供方联系人
     */
    public void setSupplierLinkman(String supplierLinkman) {
        this.supplierLinkman = supplierLinkman;
    }
    /**
     * 供方联系电话
     */
    public String getSupplierMobile() {
        return supplierMobile;
    }

    /**
     * 供方联系电话
     */
    public void setSupplierMobile(String supplierMobile) {
        this.supplierMobile = supplierMobile;
    }
    /**
     * 注册资金
     */
    public java.math.BigDecimal getSupplierRegisteredCapital() {
        return supplierRegisteredCapital;
    }

    /**
     * 注册资金
     */
    public void setSupplierRegisteredCapital(java.math.BigDecimal supplierRegisteredCapital) {
        this.supplierRegisteredCapital = supplierRegisteredCapital;
    }
    /**
     * 评价单位主键
     */
    public Long getEvaluationOrgId() {
        return evaluationOrgId;
    }

    /**
     * 评价单位主键
     */
    public void setEvaluationOrgId(Long evaluationOrgId) {
        this.evaluationOrgId = evaluationOrgId;
    }
    /**
     * 评价单位名称
     */
    public String getEvaluationOrgName() {
        return evaluationOrgName;
    }

    /**
     * 评价单位名称
     */
    public void setEvaluationOrgName(String evaluationOrgName) {
        this.evaluationOrgName = evaluationOrgName;
    }
    /**
     * 评价年度
     */
    public java.util.Date getEvaluationYear() {
        return evaluationYear;
    }

    /**
     * 评价年度
     */
    public void setEvaluationYear(java.util.Date evaluationYear) {
        this.evaluationYear = evaluationYear;
    }
    /**
     * 年度评价得分
     */
    public java.math.BigDecimal getYearEvaluationScore() {
        return yearEvaluationScore;
    }

    /**
     * 年度评价得分
     */
    public void setYearEvaluationScore(java.math.BigDecimal yearEvaluationScore) {
        this.yearEvaluationScore = yearEvaluationScore;
    }
    /**
     * 评价等级(1-合格，0-不合格)
     */
    public Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    /**
     * 评价等级(1-合格，0-不合格)
     */
    public void setEvaluationGrade(Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    /**
     * 参加考评人员
     */
    public String getAssessor() {
        return assessor;
    }

    /**
     * 参加考评人员
     */
    public void setAssessor(String assessor) {
        this.assessor = assessor;
    }
    /**
     * 供方分类主键
     */
    public Long getSupplierCategoryId() {
        return supplierCategoryId;
    }

    /**
     * 供方分类主键
     */
    public void setSupplierCategoryId(Long supplierCategoryId) {
        this.supplierCategoryId = supplierCategoryId;
    }
    /**
     * 供方分类名称
     */
    public String getSupplierCategoryName() {
        return supplierCategoryName;
    }

    /**
     * 供方分类名称
     */
    public void setSupplierCategoryName(String supplierCategoryName) {
        this.supplierCategoryName = supplierCategoryName;
    }
    /**
     * 1-分包；2-物资
     */
    public Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包；2-物资
     */
    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public List<SupplierYearReviewEvaluateEntity> getEvaluateList() {
        return evaluateList;
    }

    public void setEvaluateList(List<SupplierYearReviewEvaluateEntity> evaluateList) {
        this.evaluateList = evaluateList;
    }

    public Date getEvaluationDate() {
        return evaluationDate;
    }

    public void setEvaluationDate(Date evaluationDate) {
        this.evaluationDate = evaluationDate;
    }

    public List<SupplierYearCourseEvaluateEntity> getCourseList() {
        return courseList;
    }

    public void setCourseList(List<SupplierYearCourseEvaluateEntity> courseList) {
        this.courseList = courseList;
    }
}
