package com.ejianc.business.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supplier.bean.AccessEntity;
import com.ejianc.business.supplier.service.IAccessService;
import com.ejianc.business.supplier.utils.FeignUtil;
import com.ejianc.business.supplier.vo.AccessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商准入
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("access")
public class AccessController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private FeignUtil feignUtil;
    
    @Autowired
    private IAccessService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AccessVO> saveOrUpdate(@RequestBody AccessVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AccessVO> queryDetail(Long id) {
    	AccessEntity entity = service.selectById(id);
    	AccessVO vo = BeanMapper.map(entity, AccessVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AccessVO> vos) {
        service.removeByIds(vos.stream().map(AccessVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AccessVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<AccessEntity> page = service.queryPage(param,false);
        IPage<AccessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        
        List<AccessVO> list = BeanMapper.mapList(page.getRecords(), AccessVO.class);
        // 查询企业性质自定义档案
        Map<Long, String> defdocMap = feignUtil.getDefdocMap(304562056877981790L);
        if (CollectionUtil.isNotEmpty(list)) {
            for (AccessVO vo : list) {
                vo.setEnterpriseNatureName(defdocMap.get(vo.getEnterpriseNature()));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        pageData.setRecords(list);
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<AccessVO> list = service.excelExport(param, response);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        String billType = param.getParams().get("billType").getValue().toString();
        if (Integer.parseInt(billType) == 1) {
            ExcelExport.getInstance().export("sub-access-export.xlsx", beans, response);
        }else {
            ExcelExport.getInstance().export("material-access-export.xlsx", beans, response);
        }
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-account-import.xlsx", "银行账户导入模板");
    }
    
    /**
     * 单位银行信息导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/bankImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bankImport(HttpServletRequest request, HttpServletResponse response) {
        return CommonResponse.success("单位银行信息导入成功", service.bankImport(request, response));
    }
    
}
