package com.ejianc.business.supplier.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.supplier.bean.SupplierMisconductRecordEntity;
import com.ejianc.business.supplier.bean.SupplierReviewProjectEntity;
import com.ejianc.business.supplier.service.ISupplierCourseMisconductEvaluateService;
import com.ejianc.business.supplier.service.ISupplierMisconductRecordService;
import com.ejianc.business.supplier.service.ISupplierReviewProjectService;
import com.ejianc.business.supplier.vo.SupplierMisconductRecordVO;
import com.ejianc.business.supplier.vo.SupplierReviewProjectVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.supplier.bean.SupplierCourseEvaluateEntity;
import com.ejianc.business.supplier.service.ISupplierCourseEvaluateService;
import com.ejianc.business.supplier.vo.SupplierCourseEvaluateVO;

/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("supplierCourseEvaluate")
public class SupplierCourseEvaluateController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUPPLIER_COURSE_EVALUATE";//此处需要根据实际修改
    
    @Autowired
    private ISupplierCourseEvaluateService service;
    @Autowired
    private ISupplierReviewProjectService reviewProjectService;

    @Autowired
    private ISupplierMisconductRecordService supplierMisconductRecordService;

    @Autowired
    private ISupplierCourseMisconductEvaluateService supplierCourseMisconductEvaluateService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierCourseEvaluateVO> saveOrUpdate(@RequestBody SupplierCourseEvaluateVO saveorUpdateVO) {
    	SupplierCourseEvaluateEntity entity = BeanMapper.map(saveorUpdateVO, SupplierCourseEvaluateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            supplierCourseMisconductEvaluateService.updateDrByMisconductRecordId(entity.getId());
        }
    	service.saveOrUpdate(entity, false);
    	SupplierCourseEvaluateVO vo = BeanMapper.map(entity, SupplierCourseEvaluateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierCourseEvaluateVO> queryDetail(Long id) {
    	SupplierCourseEvaluateEntity entity = service.selectById(id);
    	SupplierCourseEvaluateVO vo = BeanMapper.map(entity, SupplierCourseEvaluateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierCourseEvaluateVO> vos) {
        service.removeByIds(vos.stream().map(SupplierCourseEvaluateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierCourseEvaluateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SupplierCourseEvaluateEntity> page = service.queryPage(param,false);
        IPage<SupplierCourseEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SupplierCourseEvaluateVO> supplierCourseEvaluateVOS = BeanMapper.mapList(page.getRecords(), SupplierCourseEvaluateVO.class);
        supplierCourseEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade()==1){
                e.setEvaluationGradeName("合格");
            }else{
                e.setEvaluationGradeName("不合格");
            }
        });
        pageData.setRecords(supplierCourseEvaluateVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SupplierCourseEvaluateEntity> list = service.queryList(param);
        List<SupplierCourseEvaluateVO> supplierCourseEvaluateVOS = BeanMapper.mapList(list, SupplierCourseEvaluateVO.class);
        supplierCourseEvaluateVOS.forEach(e -> {
            if (e.getEvaluationGrade()==1){
                e.setEvaluationGradeName("合格");
            }else{
                e.setEvaluationGradeName("不合格");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierCourseEvaluateVOS);
        Integer billType = (Integer)param.getParams().get("billType").getValue();
        if(billType==2){
            ExcelExport.getInstance().export("SupplierCourseEvaluate-export.xlsx", beans, response);
        }else {
            ExcelExport.getInstance().export("SupplierSubCourseEvaluate-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierCourseEvaluateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierCourseEvaluateVO>> refSupplierCourseEvaluateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplierCourseEvaluateEntity> page = service.queryPage(param,false);
        IPage<SupplierCourseEvaluateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierCourseEvaluateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /*
   获取评审项目
    */
    @RequestMapping(value = "/getSupplierReviewProjectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupplierReviewProjectVO>> getSupplierReviewProjectList(@RequestParam("billType") Integer billType, @RequestParam("yearType")Integer yearType){
        List<SupplierReviewProjectEntity> supplierReviewProjectList = reviewProjectService.getSupplierReviewProjectList(billType, yearType);
        List<SupplierReviewProjectVO> supplierReviewProjectVOS = BeanMapper.mapList(supplierReviewProjectList, SupplierReviewProjectVO.class);
        return CommonResponse.success(supplierReviewProjectVOS);
    }

    /*
   获取供应商不良行为记录
    */
    @RequestMapping(value = "/getSupplierMisconductRecordList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SupplierMisconductRecordVO>> getSupplierMisconductRecordList(@RequestParam("billType") Integer billType, @RequestParam("supplierId") Long supplierId){
        LambdaQueryWrapper<SupplierMisconductRecordEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SupplierMisconductRecordEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(SupplierMisconductRecordEntity::getBillType, billType);
        queryWrapper.in(SupplierMisconductRecordEntity::getBillState, 1,3);
        queryWrapper.eq(SupplierMisconductRecordEntity::getSupplierId, supplierId);
        queryWrapper.le(SupplierMisconductRecordEntity::getRecordTime, new Date());
        List<SupplierMisconductRecordEntity> list = supplierMisconductRecordService.list(queryWrapper);
        List<SupplierMisconductRecordVO> SupplierMisconductRecordVO = BeanMapper.mapList(list, SupplierMisconductRecordVO.class);
        return CommonResponse.success(SupplierMisconductRecordVO);
    }
}
