package com.ejianc.business.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.supplier.bean.SupplierYearEvaluateEntity;
import com.ejianc.business.supplier.service.ISupplierYearEvaluateService;
import com.ejianc.foundation.supplier.api.ISupplierAccountApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("supplierYearEvaluate") 
public class SupplierYearEvaluateBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISupplierAccountApi supplierAccountApi;

	@Autowired
	private ISupplierYearEvaluateService yearEvaluateService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SupplierYearEvaluateEntity supplierYearEvaluateEntity = yearEvaluateService.selectById(billId);
		if (supplierYearEvaluateEntity!=null){
			CommonResponse<String> stringCommonResponse = supplierAccountApi.syEvaluationGrade(supplierYearEvaluateEntity.getSupplierId(), supplierYearEvaluateEntity.getEvaluationGrade());
			if(stringCommonResponse.isSuccess()){
				return CommonResponse.success();
			}else{
				return CommonResponse.error("回写失败！");
			}
		} else{
			return CommonResponse.error("此单据不存在！");
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		LambdaQueryWrapper<SupplierYearEvaluateEntity> lambda = new LambdaQueryWrapper();
		lambda.eq(SupplierYearEvaluateEntity::getDr,0);
		lambda.eq(SupplierYearEvaluateEntity::getTenantId, InvocationInfoProxy.getTenantid());
		lambda.in(SupplierYearEvaluateEntity::getBillState,1,3);
		lambda.orderByDesc(SupplierYearEvaluateEntity::getUpdateTime);
		lambda.ne(SupplierYearEvaluateEntity::getId,billId);
		List<SupplierYearEvaluateEntity> list = yearEvaluateService.list(lambda);
		if (CollectionUtils.isEmpty(list)){
			supplierAccountApi.syEvaluationGrade(null,null);
		}else{
			supplierAccountApi.syEvaluationGrade(list.get(0).getSupplierId(),list.get(0).getEvaluationGrade());
		}
		return CommonResponse.success();
	}

}
