package com.ejianc.business.supplier.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商过程评价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_course_evaluate")
public class SupplierCourseEvaluateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 供方主键
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供方名称
    @TableField(value="supplier_category_id")
    private java.lang.Long supplierCategoryId; // 供方分类
    @TableField(value="supplier_category_name")
    private java.lang.String supplierCategoryName; // 供方分类名称
    @TableField(value="supplier_legal")
    private java.lang.String supplierLegal; // 供方法人
    @TableField(value="supplier_legal_phone")
    private java.lang.String supplierLegalPhone; // 供方法人电话
    @TableField(value="supplier_registered_capital")
    private java.math.BigDecimal supplierRegisteredCapital; // 注册资金
    @TableField(value="project_id")
    private java.lang.Long projectId; // 评价项目主键
    @TableField(value="project_name")
    private java.lang.String projectName; // 评价项目名称
    @TableField(value="evaluation_time")
    private java.util.Date evaluationTime; // 评价时间
    @TableField(value="evaluation_score")
    private java.math.BigDecimal evaluationScore; // 评价得分
    @TableField(value="evaluation_grade")
    private java.lang.Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    @TableField(value="assessor")
    private java.lang.String assessor; // 参加考评人员
    @TableField(value="project_manager")
    private java.lang.Long projectManager; // 项目经理
    @TableField(value="project_manager_Name")
    private java.lang.String projectManagerName; // 项目经理名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 所属组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 所属组织名称
    @TableField(value="bill_type")
    private java.lang.Integer billType; // 1-分包；2-物资
    private java.lang.Integer quarter; //季度
    @TableField(exist=false)
    @SubEntity(serviceName="supplierCourseReviewEvaluateService",pidName = "courseEvaluateId")
    private List<SupplierCourseReviewEvaluateEntity> evaluateList = new ArrayList<>(); // 供应商过程评价评审项目

    @TableField(exist=false)
    @SubEntity(serviceName="supplierCourseMisconductEvaluateService",pidName = "courseEvaluateId")
    private List<SupplierCourseMisconductEvaluateEntity> misconductRecordList = new ArrayList<>(); //


    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 供方主键
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方主键
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供方分类
     */
    public java.lang.Long getSupplierCategoryId() {
        return supplierCategoryId;
    }

    /**
     * 供方分类
     */
    public void setSupplierCategoryId(java.lang.Long supplierCategoryId) {
        this.supplierCategoryId = supplierCategoryId;
    }
    /**
     * 供方分类名称
     */
    public java.lang.String getSupplierCategoryName() {
        return supplierCategoryName;
    }

    /**
     * 供方分类名称
     */
    public void setSupplierCategoryName(java.lang.String supplierCategoryName) {
        this.supplierCategoryName = supplierCategoryName;
    }

    public String getSupplierLegal() {
        return supplierLegal;
    }

    public void setSupplierLegal(String supplierLegal) {
        this.supplierLegal = supplierLegal;
    }

    public String getSupplierLegalPhone() {
        return supplierLegalPhone;
    }

    public void setSupplierLegalPhone(String supplierLegalPhone) {
        this.supplierLegalPhone = supplierLegalPhone;
    }
    /**
     * 注册资金
     */
    public java.math.BigDecimal getSupplierRegisteredCapital() {
        return supplierRegisteredCapital;
    }

    /**
     * 注册资金
     */
    public void setSupplierRegisteredCapital(java.math.BigDecimal supplierRegisteredCapital) {
        this.supplierRegisteredCapital = supplierRegisteredCapital;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 评价时间
     */
    public java.util.Date getEvaluationTime() {
        return evaluationTime;
    }

    /**
     * 评价时间
     */
    public void setEvaluationTime(java.util.Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }
    /**
     * 评价得分
     */
    public java.math.BigDecimal getEvaluationScore() {
        return evaluationScore;
    }

    /**
     * 评价得分
     */
    public void setEvaluationScore(java.math.BigDecimal evaluationScore) {
        this.evaluationScore = evaluationScore;
    }
    /**
     * 评价等级(1-合格，0-不合格)
     */
    public java.lang.Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    /**
     * 评价等级(1-合格，0-不合格)
     */
    public void setEvaluationGrade(java.lang.Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    /**
     * 参加考评人员
     */
    public java.lang.String getAssessor() {
        return assessor;
    }

    /**
     * 参加考评人员
     */
    public void setAssessor(java.lang.String assessor) {
        this.assessor = assessor;
    }
    /**
     * 项目经理
     */
    public java.lang.Long getProjectManager() {
        return projectManager;
    }

    /**
     * 项目经理
     */
    public void setProjectManager(java.lang.Long projectManager) {
        this.projectManager = projectManager;
    }
    /**
     * 项目经理名称
     */
    public String getProjectManagerName() {
        return projectManagerName;
    }
    /**
     * 项目经理名称
     */
    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    /**
     * 所属组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 1-分包；2-物资
     */
    public java.lang.Integer getBillType() {
        return billType;
    }

    /**
     * 1-分包；2-物资
     */
    public void setBillType(java.lang.Integer billType) {
        this.billType = billType;
    }

    public Integer getQuarter() {
        return quarter;
    }

    public void setQuarter(Integer quarter) {
        this.quarter = quarter;
    }

    public List<SupplierCourseReviewEvaluateEntity> getEvaluateList() {
        return evaluateList;
    }

    public void setEvaluateList(List<SupplierCourseReviewEvaluateEntity> evaluateList) {
        this.evaluateList = evaluateList;
    }

    public List<SupplierCourseMisconductEvaluateEntity> getMisconductRecordList() {
        return misconductRecordList;
    }

    public void setMisconductRecordList(List<SupplierCourseMisconductEvaluateEntity> misconductRecordList) {
        this.misconductRecordList = misconductRecordList;
    }
}
