package com.ejianc.business.supplier.controller;

import java.io.Serializable;


import com.ejianc.business.supplier.service.ISupplierCourseMisconductEvaluateService;
import com.ejianc.business.supplier.vo.SupplierMisconductRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.supplier.bean.SupplierMisconductRecordEntity;
import com.ejianc.business.supplier.service.ISupplierMisconductRecordService;

/**
 * 供应商不良行为记录
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("supplierMisconductRecord")
public class SupplierMisconductRecordController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    private static final String BILL_CODE = "SUPPLIER_MISCONDUCT_RECORD";//此处需要根据实际修改


    @Autowired
    private ISupplierMisconductRecordService service;

    @Autowired
    private ISupplierCourseMisconductEvaluateService supplierCourseMisconductEvaluateService;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierMisconductRecordVO> saveOrUpdate(@RequestBody SupplierMisconductRecordVO saveorUpdateVO) {
    	SupplierMisconductRecordEntity entity = BeanMapper.map(saveorUpdateVO, SupplierMisconductRecordEntity.class);
    	if(entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SupplierMisconductRecordVO vo = BeanMapper.map(entity, SupplierMisconductRecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplierMisconductRecordVO> queryDetail(Long id) {
    	SupplierMisconductRecordEntity entity = service.selectById(id);
    	SupplierMisconductRecordVO vo = BeanMapper.map(entity, SupplierMisconductRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierMisconductRecordVO> vos) {
        service.removeByIds(vos.stream().map(SupplierMisconductRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplierMisconductRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SupplierMisconductRecordEntity> page = service.queryPage(param,false);
        IPage<SupplierMisconductRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierMisconductRecordVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SupplierMisconductRecordEntity> list = service.queryList(param);
        List<SupplierMisconductRecordVO> supplierMisconductRecordVOS = BeanMapper.mapList(list, SupplierMisconductRecordVO.class);
        supplierMisconductRecordVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierMisconductRecordVOS);
        Integer billType = (Integer)param.getParams().get("billType").getValue();
        if(billType==2){
            ExcelExport.getInstance().export("SupplierMisconductRecord-export.xlsx", beans, response);
        }else {
            ExcelExport.getInstance().export("SupplierSubMisconductRecord-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSupplierMisconductRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SupplierMisconductRecordVO>> refSupplierMisconductRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SupplierMisconductRecordEntity> page = service.queryPage(param,false);
        IPage<SupplierMisconductRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplierMisconductRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
