package com.ejianc.business.supplier.service.impl;

import com.ejianc.business.supplier.bean.SupplierYearCourseEvaluateEntity;
import com.ejianc.business.supplier.service.ISupplierYearCourseEvaluateService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("supplierCourseEvaluate") 
public class SupplierCourseEvaluateBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private ISupplierYearCourseEvaluateService yearCourseEvaluateService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		if (res.isSuccess()) {//单据未被下游单据引用
			List<SupplierYearCourseEvaluateEntity> list = yearCourseEvaluateService.list();
			List<Long> ids = list.stream().map(SupplierYearCourseEvaluateEntity::getYearEvaluateId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(ids) && ids.contains(billId)) {
				return CommonResponse.error("做过年度评价的季度评价不允许弃审");
			} else {
				return CommonResponse.success();
			}
		}else {
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
