package com.ejianc.business.suppliercn15.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.suppliercn15.vo.InvestigateProjectVO;
import com.ejianc.business.suppliercn15.vo.InvestigateMaterialVO;
import com.ejianc.business.suppliercn15.vo.InvestigateServiceVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商考察
 * 
 * @author generator
 * 
 */
public class InvestigateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String orgName; // 项目部
    private String orgCode; // 项目部编码
    private String billCode; // 单据编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date investigateDate; // 考察日期
    private String supplyType; // 供应商类别
    private String supplyTypeName; // 供应商类别
    private String projectName; // 项目名称
    private String passProject; // 工程是否合格
    private String scoreMaterial; // 货物考察得分
    private String standardScoreMaterial; // 货物合格分数
    private String passMaterial; // 货物是否合格
    private String scoreService; // 服务考察得分
    private String standardScoreService; // 服务合格分数
    private String passService; // 服务是否合格
    private String parentOrgName; // 所属组织
    private String parentOrgCode; // 项目部上级组织编码
    private String supplierName; // 供应商名称
    private String socialCreditCode; // 统一社会信用代码
    private String supplierLinkName; // 供应商联系人
    private String supplierLinkMobile; // 供应商联系电话
    private String investigateEmployeeId; // 考察成员
    private String investigateEmployeeName; // 考察成员名称
    private String scoreProject; // 工程考察得分
    private String standardScoreProject; // 工程合格分数
    private Integer billState; // 单据状态
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级组织Id
    
    private List<InvestigateProjectVO> investigateProjectList = new ArrayList<>(); // 供应商考察工程明细
    private List<InvestigateMaterialVO> investigateMaterialList = new ArrayList<>(); // 供应商考察货物明细
    private List<InvestigateServiceVO> investigateServiceList = new ArrayList<>(); // 供应商考察服务明细

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getInvestigateDate() {
        return investigateDate;
    }

    public void setInvestigateDate(Date investigateDate) {
        this.investigateDate = investigateDate;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getPassProject() {
        return passProject;
    }

    public void setPassProject(String passProject) {
        this.passProject = passProject;
    }
    public String getScoreMaterial() {
        return scoreMaterial;
    }

    public void setScoreMaterial(String scoreMaterial) {
        this.scoreMaterial = scoreMaterial;
    }
    public String getStandardScoreMaterial() {
        return standardScoreMaterial;
    }

    public void setStandardScoreMaterial(String standardScoreMaterial) {
        this.standardScoreMaterial = standardScoreMaterial;
    }
    public String getPassMaterial() {
        return passMaterial;
    }

    public void setPassMaterial(String passMaterial) {
        this.passMaterial = passMaterial;
    }
    public String getScoreService() {
        return scoreService;
    }

    public void setScoreService(String scoreService) {
        this.scoreService = scoreService;
    }
    public String getStandardScoreService() {
        return standardScoreService;
    }

    public void setStandardScoreService(String standardScoreService) {
        this.standardScoreService = standardScoreService;
    }
    public String getPassService() {
        return passService;
    }

    public void setPassService(String passService) {
        this.passService = passService;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkMobile() {
        return supplierLinkMobile;
    }

    public void setSupplierLinkMobile(String supplierLinkMobile) {
        this.supplierLinkMobile = supplierLinkMobile;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public String getInvestigateEmployeeId() {
        return investigateEmployeeId;
    }
    @ReferDeserialTransfer
    public void setInvestigateEmployeeId(String investigateEmployeeId) {
        this.investigateEmployeeId = investigateEmployeeId;
    }
    public String getInvestigateEmployeeName() {
        return investigateEmployeeName;
    }

    public void setInvestigateEmployeeName(String investigateEmployeeName) {
        this.investigateEmployeeName = investigateEmployeeName;
    }
    public String getScoreProject() {
        return scoreProject;
    }

    public void setScoreProject(String scoreProject) {
        this.scoreProject = scoreProject;
    }
    public String getStandardScoreProject() {
        return standardScoreProject;
    }

    public void setStandardScoreProject(String standardScoreProject) {
        this.standardScoreProject = standardScoreProject;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    
     public List<InvestigateProjectVO> getInvestigateProjectList() {
        return investigateProjectList;
     }

     public void setInvestigateProjectList(List<InvestigateProjectVO> investigateProjectList) {
        this.investigateProjectList = investigateProjectList;
     }
     public List<InvestigateMaterialVO> getInvestigateMaterialList() {
        return investigateMaterialList;
     }

     public void setInvestigateMaterialList(List<InvestigateMaterialVO> investigateMaterialList) {
        this.investigateMaterialList = investigateMaterialList;
     }
     public List<InvestigateServiceVO> getInvestigateServiceList() {
        return investigateServiceList;
     }

     public void setInvestigateServiceList(List<InvestigateServiceVO> investigateServiceList) {
        this.investigateServiceList = investigateServiceList;
     }
}
