/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.suppliercn15.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.suppliercn15.bean.InvestigateModleContentEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateModleEntity;
import com.ejianc.business.suppliercn15.service.IInvestigateModleContentService;
import com.ejianc.business.suppliercn15.service.IInvestigateModleService;
import com.ejianc.business.suppliercn15.utils.ExcelImportUtil;
import com.ejianc.business.suppliercn15.vo.InvestigateModleContentVO;
import com.ejianc.business.suppliercn15.vo.InvestigateModleDataVO;
import com.ejianc.business.suppliercn15.vo.InvestigateModleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"investigateModle"})
public class InvestigateModleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvestigateModleService service;
    @Autowired
    private IInvestigateModleContentService investigateModleContentService;
    private static final String CODE = "INVESTIGATE_MODLE_NEW";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvestigateModleVO> saveOrUpdate(@RequestBody InvestigateModleVO saveorUpdateVO) {
        List modleEntityList;
        InvestigateModleEntity entity = (InvestigateModleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InvestigateModleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse code = this.billCodeApi.getCodeBatchByRuleCode(CODE, InvocationInfoProxy.getTenantid());
            if (!code.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)code.getData());
            List listbs = saveorUpdateVO.getInvestigateModleContentEntities();
            listbs.forEach(e -> e.setId(null));
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(InvestigateModleEntity::getSupplyType, (Object)saveorUpdateVO.getSupplyType());
        lambdachange.eq(InvestigateModleEntity::getState, (Object)true);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(modleEntityList = this.service.list((Wrapper)lambdachange)))) {
            entity.setState(false);
        }
        this.service.saveOrUpdates(entity);
        InvestigateModleVO vo = (InvestigateModleVO)BeanMapper.map((Object)((Object)entity), InvestigateModleVO.class);
        vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree((List)vo.getInvestigateModleContentEntities()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryDetail(Long id) {
        InvestigateModleEntity entity = (InvestigateModleEntity)((Object)this.service.selectById(id));
        InvestigateModleVO vo = (InvestigateModleVO)BeanMapper.map((Object)((Object)entity), InvestigateModleVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())) {
            vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree((List)vo.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryCopyDetail(Long id) {
        InvestigateModleVO vo2;
        InvestigateModleEntity entity = (InvestigateModleEntity)((Object)this.service.selectById(id));
        if (CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())) {
            entity.getInvestigateModleContentEntities().forEach(vo -> vo.setRowState("add"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(vo2 = (InvestigateModleVO)BeanMapper.map((Object)((Object)entity), InvestigateModleVO.class)).getInvestigateModleContentEntities())) {
            vo2.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree((List)vo2.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo2);
    }

    @RequestMapping(value={"/queryModleDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvestigateModleDataVO> queryModleDetail() {
        InvestigateModleDataVO vo = new InvestigateModleDataVO();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(InvestigateModleEntity::getState, (Object)true);
        List list = this.service.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                if ("project".equals(e.getSupplyType())) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, (Object)e.getId());
                    List detailList = this.investigateModleContentService.list((Wrapper)lambda2);
                    vo.setInvestigateProjectModle(TreeNodeBUtil.buildTree((List)BeanMapper.mapList((Iterable)detailList, InvestigateModleContentVO.class)));
                } else if ("material".equals(e.getSupplyType())) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, (Object)e.getId());
                    List detailList = this.investigateModleContentService.list((Wrapper)lambda2);
                    vo.setInvestigateMaterialModle(TreeNodeBUtil.buildTree((List)BeanMapper.mapList((Iterable)detailList, InvestigateModleContentVO.class)));
                } else if ("service".equals(e.getSupplyType())) {
                    LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, (Object)e.getId());
                    List detailList = this.investigateModleContentService.list((Wrapper)lambda2);
                    vo.setInvestigateServiceModle(TreeNodeBUtil.buildTree((List)BeanMapper.mapList((Iterable)detailList, InvestigateModleContentVO.class)));
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateModleVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvestigateModleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvestigateModle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvestigateModleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> refInvestigateModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String supplyType = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            supplyType = conditionJson.getString("supplyType");
        }
        if (StringUtils.isNotEmpty(supplyType)) {
            param.getParams().put("supplyType", new Parameter("in", (Object)supplyType));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvestigateModleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> querySubList(Long zid) {
        QueryParam param = new QueryParam();
        param.getParams().put("zid", new Parameter("eq", (Object)zid));
        List list = this.investigateModleContentService.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, InvestigateModleContentVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)voList);
    }

    @RequestMapping(value={"/queryTypeNameList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> queryTypeNameList(String supplyTypeName) {
        List<InvestigateModleContentEntity> list = this.service.queryTypeName(supplyTypeName);
        List voList = BeanMapper.mapList(list, InvestigateModleContentVO.class);
        List treeList = TreeNodeBUtil.buildTree((List)voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)treeList);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"investigateModle-import.xlsx", (String)"\u8bc4\u4ef7\u5185\u5bb9\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<InvestigateModleContentVO> detailVoList = new ArrayList<InvestigateModleContentVO>();
            HashMap<String, Long> tidMap = new HashMap<String, Long>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                if (((String)datas.get(1)).isEmpty()) {
                    return CommonResponse.error((String)"Excel\u8003\u5bdf\u5185\u5bb9\u4e3a\u7a7a");
                }
                if (((String)datas.get(2)).isEmpty()) {
                    return CommonResponse.error((String)"Excel\u8003\u5bdf\u6807\u51c6\u4e3a\u7a7a");
                }
                if (((String)datas.get(3)).isEmpty()) {
                    return CommonResponse.error((String)"Excel\u8003\u5bdf\u5206\u6570\u4e3a\u7a7a");
                }
                if (((String)datas.get(3)).contains("-")) {
                    return CommonResponse.error((String)"\u8003\u5bdf\u5206\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                }
                InvestigateModleContentVO vo = new InvestigateModleContentVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                Long id = IdWorker.getId();
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    } else {
                        vo.setParentId(Long.valueOf(999L));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                    vo.setParentId(Long.valueOf(999L));
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setCode(null);
                    flag = true;
                } else {
                    vo.setCode((String)datas.get(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setNameContent((String)datas.get(1));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setStandard((String)datas.get(2));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    vo.setBranch((String)datas.get(3));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setShadowId(vo.getTid());
                vo.setRowState("add");
                detailVoList.add(vo);
            }
            for (InvestigateModleContentVO tVo : detailVoList) {
                tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - 1 - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/updateState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String, String> param) {
        Long id = Long.parseLong(param.get("id"));
        Boolean state = Boolean.parseBoolean(param.get("state"));
        if (state.booleanValue()) {
            InvestigateModleEntity investigateModleEntity = (InvestigateModleEntity)((Object)this.service.getById(id));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(InvestigateModleEntity::getSupplyType, (Object)investigateModleEntity.getSupplyType());
            lambdachange.eq(InvestigateModleEntity::getState, (Object)true);
            lambdachange.ne(BaseEntity::getId, (Object)id);
            List modleEntityList = this.service.list((Wrapper)lambdachange);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)modleEntityList)) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u540c\u4e00\u7c7b\u522b\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u542f\u7528\u6a21\u7248!");
            }
        }
        this.service.updateState(id, state);
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f!");
    }
}

