package com.ejianc.business.suppliercn15.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.suppliercn15.bean.InvestigateModleContentEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateModleEntity;
import com.ejianc.business.suppliercn15.service.IInvestigateModleContentService;
import com.ejianc.business.suppliercn15.service.IInvestigateModleService;
import com.ejianc.business.suppliercn15.utils.ExcelImportUtil;
import com.ejianc.business.suppliercn15.vo.InvestigateModleContentVO;
import com.ejianc.business.suppliercn15.vo.InvestigateModleDataVO;
import com.ejianc.business.suppliercn15.vo.InvestigateModleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商考察模板
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("investigateModle")
public class InvestigateModleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IInvestigateModleService service;

    @Autowired
    private IInvestigateModleContentService investigateModleContentService;


    private static final String CODE = "INVESTIGATE_MODLE_NEW";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> saveOrUpdate(@RequestBody InvestigateModleVO saveorUpdateVO) {
    	InvestigateModleEntity entity = BeanMapper.map(saveorUpdateVO, InvestigateModleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            List<InvestigateModleContentVO> listbs = saveorUpdateVO.getInvestigateModleContentEntities();
            listbs.forEach(e->{
                e.setId(null);
            });
        }
        //查询该类别下是否有启用状态数据，没有则可以启用，有的话，默认停用
        LambdaQueryWrapper<InvestigateModleEntity> lambdachange = Wrappers.<InvestigateModleEntity>lambdaQuery();
        lambdachange.eq(InvestigateModleEntity::getSupplyType, saveorUpdateVO.getSupplyType());
        lambdachange.eq(InvestigateModleEntity::getState, true);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            lambdachange.ne(InvestigateModleEntity::getId, saveorUpdateVO.getId());
        }
        List<InvestigateModleEntity> modleEntityList = service.list(lambdachange);
        if(CollectionUtils.isNotEmpty(modleEntityList)){
            entity.setState(false); //查询该类别下 有启用状态数据 则该数据默认停用
        }
        service.saveOrUpdates(entity);

        InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryDetail(Long id) {
    	InvestigateModleEntity entity = service.selectById(id);

    	InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        if(CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())){
            vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateModleVO> queryCopyDetail(Long id) {
        InvestigateModleEntity entity = service.selectById(id);

        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(entity.getInvestigateModleContentEntities())){
            entity.getInvestigateModleContentEntities().forEach(vo -> {
                vo.setRowState("add");
            });
        }
        InvestigateModleVO vo = BeanMapper.map(entity, InvestigateModleVO.class);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(vo.getInvestigateModleContentEntities())){
            vo.setInvestigateModleContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateModleContentEntities()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryModleDetail 查询启用模版的详情
     * @param
     */
    @RequestMapping(value = "/queryModleDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateModleDataVO> queryModleDetail() {
        InvestigateModleDataVO vo = new InvestigateModleDataVO();
        //查询该类别下是否有启用状态数据，没有则可以启用，有的话，默认停用
        LambdaQueryWrapper<InvestigateModleEntity> lambda = Wrappers.<InvestigateModleEntity>lambdaQuery();
        lambda.eq(InvestigateModleEntity::getState, true);
        List<InvestigateModleEntity> list = service.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                if("project".equals(e.getSupplyType())){
                    LambdaQueryWrapper<InvestigateModleContentEntity> lambda2 = Wrappers.<InvestigateModleContentEntity>lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, e.getId());
                    List<InvestigateModleContentEntity> detailList = investigateModleContentService.list(lambda2);
                    vo.setStandardScoreProject(e.getStandardScore());
                    vo.setInvestigateProjectModle(TreeNodeBUtil.buildTree(BeanMapper.mapList(detailList,InvestigateModleContentVO.class)));
                }else if("material".equals(e.getSupplyType())){
                    LambdaQueryWrapper<InvestigateModleContentEntity> lambda2 = Wrappers.<InvestigateModleContentEntity>lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, e.getId());
                    List<InvestigateModleContentEntity> detailList = investigateModleContentService.list(lambda2);
                    vo.setStandardScoreMaterial(e.getStandardScore());
                    vo.setInvestigateMaterialModle(TreeNodeBUtil.buildTree(BeanMapper.mapList(detailList,InvestigateModleContentVO.class)));
                }else if("service".equals(e.getSupplyType())){
                    LambdaQueryWrapper<InvestigateModleContentEntity> lambda2 = Wrappers.<InvestigateModleContentEntity>lambdaQuery();
                    lambda2.eq(InvestigateModleContentEntity::getZid, e.getId());
                    List<InvestigateModleContentEntity> detailList = investigateModleContentService.list(lambda2);
                    vo.setStandardScoreService(e.getStandardScore());
                    vo.setInvestigateServiceModle(TreeNodeBUtil.buildTree(BeanMapper.mapList(detailList,InvestigateModleContentVO.class)));
                }
            });
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }



    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateModleVO> vos) {
        service.removeByIds(vos.stream().map(InvestigateModleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InvestigateModleEntity> page = service.queryPage(param,false);
        IPage<InvestigateModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateModleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvestigateModleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InvestigateModle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refInvestigateModleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvestigateModleVO>> refInvestigateModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String supplyType =null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            JSONObject conditionJson = JSONObject.parseObject(condition);
            supplyType = conditionJson.getString("supplyType");
        }
        //类型
        if(StringUtils.isNotEmpty(supplyType)){
            param.getParams().put("supplyType", new Parameter(QueryParam.IN, supplyType));
        }
        IPage<InvestigateModleEntity> page = service.queryPage(param,false);
        IPage<InvestigateModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateModleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据主表id查询子数据
     * @param zid
     * @return
     */
    @RequestMapping(value = "/querySubList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> querySubList(Long zid) {
        QueryParam param = new QueryParam();
        param.getParams().put("zid", new Parameter(QueryParam.EQ, zid));
        List<InvestigateModleContentEntity> list =investigateModleContentService.queryList(param);
        List<InvestigateModleContentVO> voList =BeanMapper.mapList(list,InvestigateModleContentVO.class);
        return CommonResponse.success("查询数据成功！",voList);
    }

    /**
     * 根据主表id查询子数据
     * @param
     * @return
     */
    @RequestMapping(value = "/queryTypeNameList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InvestigateModleContentVO>> queryTypeNameList(String supplyTypeName) {
        List<InvestigateModleContentEntity> list =service.queryTypeName(supplyTypeName);
        List<InvestigateModleContentVO> voList =BeanMapper.mapList(list,InvestigateModleContentVO.class);
        List<InvestigateModleContentVO> treeList =TreeNodeBUtil.buildTree(voList);
        return CommonResponse.success("查询数据成功！",treeList);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "investigateModle-import.xlsx", "评价内容导入模板");
    }

    /**
     * 导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<InvestigateModleContentVO> detailVoList = new ArrayList<>();
                Map<String, Long> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    if(datas.get(1).isEmpty()){
                        return CommonResponse.error("Excel考察内容为空");
                    }
                    if(datas.get(2).isEmpty()){
                        return CommonResponse.error("Excel考察标准为空");
                    }
                    if(datas.get(3).isEmpty()){
                        return CommonResponse.error("Excel考察分数为空");
                    }
                    if(datas.get(3).contains("-") ){
                        return CommonResponse.error("考察分数不能为负数");
                    }
                    InvestigateModleContentVO vo = new InvestigateModleContentVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    //维护父子关系
                    Long id = Long.valueOf(IdWorker.getId());
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);

                        if (split.length > 2) {
                            return CommonResponse.error("仅支持导入两级结构！");
                        }else if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }else{
                            vo.setParentId(999L);
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                        vo.setParentId(999L);
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(0))) {
                        vo.setCode(null);
                        flag = true;
                    } else {
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isNotEmpty(datas.get(1))) {
                        vo.setNameContent(datas.get(1));
                    }
                    if (StringUtils.isNotEmpty(datas.get(2))) {
                        vo.setStandard(datas.get(2));
                    }
                    if (StringUtils.isNotEmpty(datas.get(3))) {
                        vo.setBranch(datas.get(3));
                    }
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setShadowId(vo.getTid());
                    vo.setRowState("add");
                    detailVoList.add(vo);
                }

                for (InvestigateModleContentVO tVo : detailVoList) {
                    tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - 1 - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 修改状态
     * @param param
     * @return
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String,String> param){
        Long id = Long.parseLong(param.get("id"));
        Boolean state =  Boolean.parseBoolean(param.get("state"));
        if(state){
            InvestigateModleEntity investigateModleEntity = service.getById(id);
            //查询该类别下是否有启用状态数据，没有则可以启用，有的话，默认停用
            LambdaQueryWrapper<InvestigateModleEntity> lambdachange = Wrappers.<InvestigateModleEntity>lambdaQuery();
            lambdachange.eq(InvestigateModleEntity::getSupplyType, investigateModleEntity.getSupplyType());
            lambdachange.eq(InvestigateModleEntity::getState, true);
            lambdachange.ne(InvestigateModleEntity::getId, id);
            List<InvestigateModleEntity> modleEntityList = service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(modleEntityList)){
                throw new BusinessException("操作失败，同一类别下只能有一个启用模版!");
            }
        }
        service.updateState(id,state);
        return CommonResponse.success("修改状态成功!");
    }
}
