package com.ejianc.business.suppliercn15.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.suppliercn15.bean.InvestigateProjectEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateMaterialEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateServiceEntity;
/**
 * 供应商考察
 * 
 * @author generator
 * 
 */
 @TableName("ejc_suppliercn15_investigate")
public class InvestigateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_name")
    private String orgName; // 项目部
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="investigate_date")
    private Date investigateDate; // 考察日期
    @TableField(value="supply_type")
    private String supplyType; // 供应商类别
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供应商类别
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="pass_project")
    private String passProject; // 工程是否合格
    @TableField(value="score_material")
    private String scoreMaterial; // 货物考察得分
    @TableField(value="standard_score_material")
    private String standardScoreMaterial; // 货物合格分数
    @TableField(value="pass_material")
    private String passMaterial; // 货物是否合格
    @TableField(value="score_service")
    private String scoreService; // 服务考察得分
    @TableField(value="standard_score_service")
    private String standardScoreService; // 服务合格分数
    @TableField(value="pass_service")
    private String passService; // 服务是否合格
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="supplier_link_name")
    private String supplierLinkName; // 供应商联系人
    @TableField(value="supplier_link_mobile")
    private String supplierLinkMobile; // 供应商联系电话
    @TableField(value="investigate_employee_id")
    private String investigateEmployeeId; // 考察成员
    @TableField(value="investigate_employee_name")
    private String investigateEmployeeName; // 考察成员名称
    @TableField(value="score_project")
    private String scoreProject; // 工程考察得分
    @TableField(value="standard_score_project")
    private String standardScoreProject; // 工程合格分数
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="investigateProjectService",pidName = "zid")
    private List<InvestigateProjectEntity> investigateProjectList = new ArrayList<>(); // 供应商考察工程明细
    @TableField(exist=false)
    @SubEntity(serviceName="investigateMaterialService",pidName = "zid")
    private List<InvestigateMaterialEntity> investigateMaterialList = new ArrayList<>(); // 供应商考察货物明细
    @TableField(exist=false)
    @SubEntity(serviceName="investigateServiceService",pidName = "zid")
    private List<InvestigateServiceEntity> investigateServiceList = new ArrayList<>(); // 供应商考察服务明细
    

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getInvestigateDate() {
        return investigateDate;
    }

    public void setInvestigateDate(Date investigateDate) {
        this.investigateDate = investigateDate;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getPassProject() {
        return passProject;
    }

    public void setPassProject(String passProject) {
        this.passProject = passProject;
    }
    public String getScoreMaterial() {
        return scoreMaterial;
    }

    public void setScoreMaterial(String scoreMaterial) {
        this.scoreMaterial = scoreMaterial;
    }
    public String getStandardScoreMaterial() {
        return standardScoreMaterial;
    }

    public void setStandardScoreMaterial(String standardScoreMaterial) {
        this.standardScoreMaterial = standardScoreMaterial;
    }
    public String getPassMaterial() {
        return passMaterial;
    }

    public void setPassMaterial(String passMaterial) {
        this.passMaterial = passMaterial;
    }
    public String getScoreService() {
        return scoreService;
    }

    public void setScoreService(String scoreService) {
        this.scoreService = scoreService;
    }
    public String getStandardScoreService() {
        return standardScoreService;
    }

    public void setStandardScoreService(String standardScoreService) {
        this.standardScoreService = standardScoreService;
    }
    public String getPassService() {
        return passService;
    }

    public void setPassService(String passService) {
        this.passService = passService;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkMobile() {
        return supplierLinkMobile;
    }

    public void setSupplierLinkMobile(String supplierLinkMobile) {
        this.supplierLinkMobile = supplierLinkMobile;
    }
    public String getInvestigateEmployeeId() {
        return investigateEmployeeId;
    }

    public void setInvestigateEmployeeId(String investigateEmployeeId) {
        this.investigateEmployeeId = investigateEmployeeId;
    }
    public String getInvestigateEmployeeName() {
        return investigateEmployeeName;
    }

    public void setInvestigateEmployeeName(String investigateEmployeeName) {
        this.investigateEmployeeName = investigateEmployeeName;
    }
    public String getScoreProject() {
        return scoreProject;
    }

    public void setScoreProject(String scoreProject) {
        this.scoreProject = scoreProject;
    }
    public String getStandardScoreProject() {
        return standardScoreProject;
    }

    public void setStandardScoreProject(String standardScoreProject) {
        this.standardScoreProject = standardScoreProject;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    

    public List<InvestigateProjectEntity> getInvestigateProjectList() {
        return investigateProjectList;
    }

    public void setInvestigateProjectList(List<InvestigateProjectEntity> investigateProjectList) {
        this.investigateProjectList = investigateProjectList;
    }

    public List<InvestigateMaterialEntity> getInvestigateMaterialList() {
        return investigateMaterialList;
    }

    public void setInvestigateMaterialList(List<InvestigateMaterialEntity> investigateMaterialList) {
        this.investigateMaterialList = investigateMaterialList;
    }

    public List<InvestigateServiceEntity> getInvestigateServiceList() {
        return investigateServiceList;
    }

    public void setInvestigateServiceList(List<InvestigateServiceEntity> investigateServiceList) {
        this.investigateServiceList = investigateServiceList;
    }
}
