package com.ejianc.business.suppliercn15.controller;

import java.io.Serializable;

import com.ejianc.business.suppliercn15.bean.InvestigateMaterialEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateProjectEntity;
import com.ejianc.business.suppliercn15.bean.InvestigateServiceEntity;
import com.ejianc.business.suppliercn15.service.IInvestigateMaterialService;
import com.ejianc.business.suppliercn15.service.IInvestigateProjectService;
import com.ejianc.business.suppliercn15.service.IInvestigateServiceService;
import com.ejianc.business.suppliercn15.vo.InvestigateMaterialVO;
import com.ejianc.business.suppliercn15.vo.InvestigateProjectVO;
import com.ejianc.business.suppliercn15.vo.InvestigateServiceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.suppliercn15.bean.InvestigateEntity;
import com.ejianc.business.suppliercn15.service.IInvestigateService;
import com.ejianc.business.suppliercn15.vo.InvestigateVO;

/**
 * 供应商考察
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("investigate")
public class InvestigateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "INVESTIGATE_CODE_NEW";//此处需要根据实际修改

    @Autowired
    private IInvestigateService service;

    @Autowired
    private IInvestigateProjectService investigateProjectService;

    @Autowired
    private IInvestigateMaterialService investigateMaterialService;

    @Autowired
    private IInvestigateServiceService investigateServiceService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvestigateVO> saveOrUpdate(@RequestBody InvestigateVO saveOrUpdateVO) {
    	InvestigateEntity entity = BeanMapper.map(saveOrUpdateVO, InvestigateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

    	if(CollectionUtils.isNotEmpty(entity.getInvestigateProjectList())){
            List<InvestigateProjectEntity> listbs = entity.getInvestigateProjectList();
            Map<Long,Long> idMap=new HashMap<>();
            for(InvestigateProjectEntity cdEntity:listbs){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(InvestigateProjectEntity cdEntity:listbs){
                if(999L!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());

                }else{
                    cdEntity.setTid(cdEntity.getId());
                }
            }
            investigateProjectService.saveOrUpdateBatch(listbs,listbs.size(),false);
        }

        if(CollectionUtils.isNotEmpty(entity.getInvestigateMaterialList())){
            List<InvestigateMaterialEntity> listbs = entity.getInvestigateMaterialList();
            Map<Long,Long> idMap=new HashMap<>();
            for(InvestigateMaterialEntity cdEntity:listbs){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(InvestigateMaterialEntity cdEntity:listbs){
                if(999L!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());

                }else{
                    cdEntity.setTid(cdEntity.getId());
                }
            }
            investigateMaterialService.saveOrUpdateBatch(listbs,listbs.size(),false);
        }

        if(CollectionUtils.isNotEmpty(entity.getInvestigateServiceList())){
            List<InvestigateServiceEntity> listbs = entity.getInvestigateServiceList();
            Map<Long,Long> idMap=new HashMap<>();
            for(InvestigateServiceEntity cdEntity:listbs){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(InvestigateServiceEntity cdEntity:listbs){
                if(999L!=cdEntity.getParentId()){
                    cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());

                }else{
                    cdEntity.setTid(cdEntity.getId());
                }
            }
            investigateServiceService.saveOrUpdateBatch(listbs,listbs.size(),false);
        }


    	InvestigateVO vo = BeanMapper.map(entity, InvestigateVO.class);
    	return queryDetail(entity.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvestigateVO> queryDetail(Long id) {
    	InvestigateEntity entity = service.selectById(id);
    	InvestigateVO vo = BeanMapper.map(entity, InvestigateVO.class);

        if(CollectionUtils.isNotEmpty(entity.getInvestigateProjectList())){
            vo.setInvestigateProjectList(TreeNodeBUtil.buildTree(vo.getInvestigateProjectList().stream().sorted(Comparator.comparing(InvestigateProjectVO::getCode)).collect(Collectors.toList())));
        }
        if(CollectionUtils.isNotEmpty(entity.getInvestigateMaterialList())){
            vo.setInvestigateMaterialList(TreeNodeBUtil.buildTree(vo.getInvestigateMaterialList().stream().sorted(Comparator.comparing(InvestigateMaterialVO::getCode)).collect(Collectors.toList())));
        }
        if(CollectionUtils.isNotEmpty(entity.getInvestigateServiceList())){
            vo.setInvestigateServiceList(TreeNodeBUtil.buildTree(vo.getInvestigateServiceList().stream().sorted(Comparator.comparing(InvestigateServiceVO::getCode)).collect(Collectors.toList())));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InvestigateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InvestigateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplyTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<InvestigateEntity> page = service.queryPage(param,false);
        IPage<InvestigateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InvestigateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Investigate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refInvestigateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> refInvestigateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("socialCreditCode")) {
                param.getParams().put("social_credit_code", new Parameter(QueryParam.EQ, _con.get("socialCreditCode")));
            }
        }
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        IPage<InvestigateEntity> page = service.queryPage(param,false);
        IPage<InvestigateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvestigateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
