/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.suppliercn15.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.suppliercn15.bean.InvestigateEntity;
import com.ejianc.business.suppliercn15.service.IInvestigateMaterialService;
import com.ejianc.business.suppliercn15.service.IInvestigateProjectService;
import com.ejianc.business.suppliercn15.service.IInvestigateService;
import com.ejianc.business.suppliercn15.service.IInvestigateServiceService;
import com.ejianc.business.suppliercn15.vo.InvestigateMaterialVO;
import com.ejianc.business.suppliercn15.vo.InvestigateProjectVO;
import com.ejianc.business.suppliercn15.vo.InvestigateServiceVO;
import com.ejianc.business.suppliercn15.vo.InvestigateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"investigate"})
public class InvestigateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "INVESTIGATE_CODE_NEW";
    @Autowired
    private IInvestigateService service;
    @Autowired
    private IInvestigateProjectService investigateProjectService;
    @Autowired
    private IInvestigateMaterialService investigateMaterialService;
    @Autowired
    private IInvestigateServiceService investigateServiceService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvestigateVO> saveOrUpdate(@RequestBody InvestigateVO saveOrUpdateVO) {
        HashMap<Long, Long> idMap;
        List<BaseEntity> listbs;
        InvestigateEntity entity = (InvestigateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InvestigateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(entity.getInvestigateProjectList())) {
            listbs = entity.getInvestigateProjectList();
            idMap = new HashMap<Long, Long>();
            for (BaseEntity cdEntity : listbs) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BaseEntity cdEntity : listbs) {
                if (999L != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());
                    continue;
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.investigateProjectService.saveOrUpdateBatch(listbs, listbs.size(), false);
        }
        if (CollectionUtils.isNotEmpty(entity.getInvestigateMaterialList())) {
            listbs = entity.getInvestigateMaterialList();
            idMap = new HashMap();
            for (BaseEntity cdEntity : listbs) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BaseEntity cdEntity : listbs) {
                if (999L != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());
                    continue;
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.investigateMaterialService.saveOrUpdateBatch(listbs, listbs.size(), false);
        }
        if (CollectionUtils.isNotEmpty(entity.getInvestigateServiceList())) {
            listbs = entity.getInvestigateServiceList();
            idMap = new HashMap();
            for (BaseEntity cdEntity : listbs) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BaseEntity cdEntity : listbs) {
                if (999L != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                    cdEntity.setTid(cdEntity.getId());
                    continue;
                }
                cdEntity.setTid(cdEntity.getId());
            }
            this.investigateServiceService.saveOrUpdateBatch(listbs, listbs.size(), false);
        }
        InvestigateVO vo = (InvestigateVO)BeanMapper.map((Object)((Object)entity), InvestigateVO.class);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvestigateVO> queryDetail(Long id) {
        InvestigateEntity entity = (InvestigateEntity)((Object)this.service.selectById(id));
        InvestigateVO vo = (InvestigateVO)BeanMapper.map((Object)((Object)entity), InvestigateVO.class);
        if (CollectionUtils.isNotEmpty(entity.getInvestigateProjectList())) {
            vo.setInvestigateProjectList(TreeNodeBUtil.buildTree(vo.getInvestigateProjectList().stream().sorted(Comparator.comparing(InvestigateProjectVO::getCode)).collect(Collectors.toList())));
        }
        if (CollectionUtils.isNotEmpty(entity.getInvestigateMaterialList())) {
            vo.setInvestigateMaterialList(TreeNodeBUtil.buildTree(vo.getInvestigateMaterialList().stream().sorted(Comparator.comparing(InvestigateMaterialVO::getCode)).collect(Collectors.toList())));
        }
        if (CollectionUtils.isNotEmpty(entity.getInvestigateServiceList())) {
            vo.setInvestigateServiceList(TreeNodeBUtil.buildTree(vo.getInvestigateServiceList().stream().sorted(Comparator.comparing(InvestigateServiceVO::getCode)).collect(Collectors.toList())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvestigateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InvestigateVO investigateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("supplyTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvestigateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Investigate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInvestigateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvestigateVO>> refInvestigateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"socialCreditCode")) {
            param.getParams().put("social_credit_code", new Parameter("eq", _con.get((Object)"socialCreditCode")));
        }
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvestigateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

