/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.framework.core.exception.BusinessException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PSRMRestUtil {
    private static final Logger logger = LoggerFactory.getLogger(PSRMRestUtil.class);
    public static String SUCCESS_RETURNCODE = "0";
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).build();
    private static final MediaType mediaType = MediaType.parse((String)"application/json");
    @Value(value="${psrm.restUrl:http://192.168.20.190/upms/rest}")
    private String restUrl;
    @Value(value="${psrm.userCode:admin}")
    private String userCode;
    @Value(value="${psrm.password:698d51a19d8a121ce581499d7b701668}")
    private String password;
    @Value(value="${psrm.runMode:false}")
    private Boolean runMode;

    public PSRMResponse postReq(JSONObject content, String methodName) {
        try {
            logger.info("======================={}===========================================", (Object)methodName);
            String url = this.restUrl + "/psrm/rest?com_id=1&method=" + methodName + "&token=" + this.getToken();
            logger.info("\u8bf7\u6c42url\uff1a{}", (Object)url);
            logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)content.toJSONString());
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)content.toJSONString());
            Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            PSRMResponse resp = (PSRMResponse)JSON.parseObject((String)resBody, PSRMResponse.class);
            logger.info("\u539f\u59cb\u54cd\u5e94: {}", (Object)resBody);
            logger.info("\u54cd\u5e94: {}", (Object)JSON.toJSONString((Object)resp));
            logger.info("======================={}===========================================", (Object)methodName);
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getToken() {
        try {
            JSONObject content = new JSONObject();
            content.put("f_code", (Object)this.userCode);
            content.put("f_password", (Object)this.password);
            content.put("orgId", (Object)"1");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)content.toJSONString());
            Request request = new Request.Builder().url(this.restUrl + "/upms/rest?com_id=0&method=upms.user.login&token=undefined").method("POST", body).addHeader("Content-Type", "application/json;charset=utf-8").build();
            Response response = HTTP_CLIENT.newCall(request).execute();
            String resBody = response.body().string();
            JSONObject json = JSON.parseObject((String)resBody);
            if (!"0".equals(json.get((Object)"returncode"))) {
                throw new BusinessException("\u83b7\u53d6\u6570\u636e\u4e2d\u53f0Token\u5931\u8d25\uff1a" + json.getString("data"));
            }
            String token = json.getJSONObject("data").getJSONObject("upms_user").getString("token");
            logger.info("PSRM Token: {}", (Object)token);
            return token;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean isRunMode() {
        return this.runMode;
    }
}

