package com.ejianc.foundation.share.api;

import com.ejianc.foundation.share.hystrix.CategoryBrandHystrix;
import com.ejianc.foundation.share.vo.CategoryBrandVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 物资rpc服务
 *
 * @author ljl
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = CategoryBrandHystrix.class)
public interface ICategoryBrandApi {

    @PostMapping("/api/categoryBrandApi/queryWhetherByCtyIds")
    @ResponseBody
    CommonResponse<List<CategoryBrandVO>> queryWhetherByCtyIds(@RequestBody List<Long> ctyIdList);
}
