package com.ejianc.foundation.share.util;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.List;


/**
 * @description: PSRMResponse
 * @author songlx
 * @date 2025/3/25
 * @version 1.0
 */
public class PSRMResponse implements Serializable {

    private static final Logger logger = LoggerFactory.getLogger(PSRMResponse.class);

    public static String SUCCESS_RETURNCODE = "0";

    private String returncode = "0";

    private PSRMData data;

    private List<String> warnmsg;


    public String getReturncode() {
        return returncode;
    }

    public void setReturncode(String returncode) {
        this.returncode = returncode;
    }

    public PSRMData getData() {
        return data;
    }

    public void setData(PSRMData data) {
        this.data = data;
    }

    public List<String> getWarnmsg() {
        return warnmsg;
    }

    public void setWarnmsg(List<String> warnmsg) {
        this.warnmsg = warnmsg;
    }

    public static PSRMResponse success() {
        PSRMResponse result = new PSRMResponse();
        result.setReturncode(SUCCESS_RETURNCODE);
        return result;
    }

    @JSONField(serialize = false)
    @JsonIgnore
    public boolean isSuccess() {
        return SUCCESS_RETURNCODE.equals(this.getReturncode());
    }

    @JSONField(serialize = false)
    @JsonIgnore
    public String getPsrmCode() {
        if (this.isSuccess()) {
            return this.getData().getF_code().get(0);
        }
        return null;
    }

}
