package com.ejianc.foundation.share.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.share.hystrix.MaterialHystrix;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 物资rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = MaterialHystrix.class)
public interface IMaterialApi {

	/**
	 * 根据物资名称、规格型号、计量单位、物料分类进行唯一性查询
	 *
	 * @param materialVO(name,spac,unitName,categoryId,property)
	 * @return
	 */
	@PostMapping(value = "/api/materialApi/queryExitFlag")
	public CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO);
	/**
	 * 根据物资名称、规格型号、计量单位、物料分类名称进行唯一性查询
	 *
	 * @param materialVO(name,spec,unitName,categoryName,property)
	 * @return
	 */
	@PostMapping(value = "/api/materialApi/queryExcelFlag")
	public CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO);

	/**
	 * 根据编码查询物料分类详情
	 *
	 * @param code
	 * @param tenantId 租户Id
	 * @param count
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryByCode")
	public CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据父id询全部物料分类
	 *
	 * @param id
	 * @param tenantId 租户Id
	 * @param count
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryListByPid")
	public CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id);

	/**
	 * 根据ids查询上级全部分类
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryListByChildren")
	CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/19 根据sourceId查询物资
	 * @Description queryMaterialBySourceId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/materialApi/queryMaterialBySourceId")
	CommonResponse<MaterialVO> queryMaterialBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author liyj
	 * @Date 2020/10/29 根据ids查询物资列表（包括物资来源id，物资分类来源id）
	 * @Param [ids]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
	 */
	@GetMapping(value = "/api/materialApi/queryMaterialByIds")
	CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据主键查询物料分类详情
	 * @Author zhangwx
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/materialApi/queryCategoryById")
	 CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id);
}
