package com.ejianc.foundation.support.api;

import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.hystrix.BillTypeHystrix;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 自动编码获取rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = BillTypeHystrix.class)
public interface IBillTypeApi {

	/**
	 * 根据单据编码获取单据信息
	 *
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/getByCode")
	public CommonResponse<BillTypeVO> getByCode(@RequestParam(value = "code") String code);

	/**
	 * 根据单据类型Id查询单据类型信息
	 *
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/getById")
	public CommonResponse<BillTypeVO> getById(@RequestParam(value = "id") Long id);

	/**
	 * 根据billType查询详情
	 * 
	 * @param refCode
	 * @return
	 */
	@RequestMapping(value = "/api/billTypeApi/queryMetadataByBillType", method=RequestMethod.GET)
	public CommonResponse<MdReferVO> queryMetadataByBillType(@RequestParam(value="billTypeCode", required=true) String billTypeCode);

	/**
	 * 根据单据编码引用检查
	 *
	 * @param code
	 * @return
	 */
	@GetMapping(value = "/api/billTypeApi/checkQuote")
	public CommonResponse<String> checkQuote(@RequestParam(value = "billTypeCode") String billTypeCode,@RequestParam(value = "billId") Long billId);
}
