package com.ejianc.foundation.support.api;

import com.ejianc.foundation.support.hystrix.DefdocHystrix;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 自定义档案rpc服务
 * 
 * @author guoming
 *
 */	
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = DefdocHystrix.class)
public interface IDefdocApi {
	
	/**
	 * 根据档案编码查询档案信息
	 * 
	 * @param defdocCode
	 * @return
	 */
	@RequestMapping(value = "/api/def_doc/getDefdocByDefCode", method=RequestMethod.GET)
	public CommonResponse<DefdocVO> getDefdocByDefCode(@RequestParam(value="defdocCode") String defdocCode);
	
	@RequestMapping(value = "/api/def_doc/getDefDocById", method=RequestMethod.GET)
	public CommonResponse<DefdocDetailVO> getDefDocById(@RequestParam(value="id") Long id);

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/15 根据档案id（注意：不是档案项id） 查询该档案所有档案项
	 * @Description getDefDocByName
	 * @Param defId 档案id（注意：不是档案项id）
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "/api/def_doc/getDefDocByDefId", method=RequestMethod.GET)
	public CommonResponse<List<DefdocDetailVO>> getDefDocByDefId(@RequestParam(value="defId") Long defId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2021-9-14 根据档案编码  查询该档案所有档案项
	 * @Description getDefDocByDefCode
	 * @Param defCode 档案编码
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "/api/def_doc/getDefDocByDefCode", method=RequestMethod.GET)
	CommonResponse<List<DefdocDetailVO>> getDefDocByDefCode(@RequestParam(value="defCode") String defCode);


	/**
	 * @Author mrsir_wxp
	 * @Date 2021-9-14 根据档案编码  查询该档案所有档案项 需要传租户id
	 * @Description getDefDocDetailByDefCode
	 * @Param defCode 档案编码
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "/api/def_doc/getDefDocDetailByDefCodeAndTenantId", method=RequestMethod.GET)
	CommonResponse<List<DefdocDetailVO>> getDefDocDetailByDefCodeAndTenantId(@RequestParam(value="defCode") String defCode,@RequestParam(value="tenantId") Long tenantId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/1/15 根据档案id（注意：不是档案项id）和档案项名称，精准查询档案项详情
	 * @Description getDefDocByName
	 * @Param defDocId 档案id（注意：不是档案项id）
	 * @Param name 档案项名称
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.DefdocDetailVO>
	 */
	@RequestMapping(value = "/api/def_doc/getDefDocByName", method=RequestMethod.GET)
	public CommonResponse<DefdocDetailVO> getDefDocByName(@RequestParam(value="defDocId") Long defDocId,@RequestParam(value="name") String name);

	/**
	 * 查询档案详情api
	 * @param defdocTypeCode
	 * @param condition
	 * @return
	 */
	@GetMapping("/api/def_doc/detailListByDefdocCode")
	@ResponseBody
	public CommonResponse<List<Map<String, Object>>> queryDetailListByDefdocCode(@RequestParam(value = "defdocTypeCode") String defdocTypeCode,
																				 @RequestParam(value = "condition", required = false) String condition);


	@GetMapping(value = "/api/def_doc/detailListByDetailNamesAndDocCode")
	public CommonResponse<List<DefdocDetailVO>>  detailListByDetailNamesAndDocCode(@RequestParam String[] detailNames, @RequestParam String docCode);
	@GetMapping(value = "/api/def_doc/no_auth/detailListByDetailNamesAndDocCode")
	public CommonResponse<List<DefdocDetailVO>>  noAuthDetailListByDetailNamesAndDocCode(@RequestParam List<String> detailNames, @RequestParam String docCode);


	/**
	 * 根据档案编码批量查询档案详情api
	 * @param defdocTypeCodeList
	 * @return
	 */
	@GetMapping("/api/def_doc/detailListByDefdocCodeList")
	@ResponseBody
	public CommonResponse<List<DefdocDetailVO>> queryDetailListByDefdocCodeList(@RequestParam(value = "defdocTypeCodeList") List<String> defdocTypeCodeList);



}
