package com.ejianc.foundation.initData.api;

import com.ejianc.foundation.initData.hystrix.InitDataHystrix;
import com.ejianc.foundation.initData.vo.EnterpriseInitVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author mrsir_wxp
 * @Date 2020/7/7 用于租户审核通过之后生成租户的物资设备表，自定义档案表，以及回滚等操作
 * @Description InitDataApi
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = InitDataHystrix.class)
public interface InitDataApi {

    @PostMapping(value = "/api/initDataApi/initData")
    void initData(@RequestBody EnterpriseInitVO vo);

    @PostMapping(value = "/api/initDataApi/rollBack")
    void rollBack(@RequestParam("tenantId") Long tenantId);
}
