package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.hystrix.SupplierAccountHystrix;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = SupplierAccountHystrix.class)
public interface ISupplierAccountApi {
    /**
     * 同步准入数据
     *
     * @return
     */
    @RequestMapping(value = "/api/supplierAccountApi/sysSupplier", method = RequestMethod.POST)
    public CommonResponse<String> sysSupplier(@RequestBody SuplSupplierVO supplierVo);
    /**
     * 同步评价等级
     * @param supplierId
     * @param evaluationGrade
     * @return
     */
    @GetMapping("/api/supplierAccountApi/syEvaluationGrade")
    public CommonResponse<String> syEvaluationGrade(@RequestParam(value = "supplierId") Long supplierId,
                                                    @RequestParam(value = "evaluationGrade") Integer evaluationGrade);
    /**
     * 根据准入查询供方
     *
     * @param accessId
     * @return
     */
    @GetMapping("/api/supplierAccountApi/getSupplierByAccessId")
    public CommonResponse<List<SupplierVO>> getSupplierByAccessId(@RequestParam(value = "accessId") Long accessId);
}
