package com.ejianc.foundation.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 供应商处置
 * 
 * @author generator
 * 
 */
public class SupplierPunishVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long supplyId; // 供应商id
    private String supplyCode; // 供应商编码
    private String supplyName; // 供应商名称
    private Long punishType; // 处置方式
    private String punishTypeName; // 处置方式
    private Long applyOrgId; // 申请单位
    private String applyOrg; // 申请单位
    private Long applyPersonId; // 申请人
    private String applyPerson; // 申请人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请时间
    private String memo; // 理由说明
    private String code; // 处置编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date punishLastTime; // 处置结束时间
    private String pushState; // 处置状态：1：未生效；2：生效中，3：已过期，4：已作废
    private String rmCode; // 移除单编码
    private Long rmId; // 移除单id

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="zy_supplier")
    public Long getSupplyId() {
        return supplyId;
    }
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }

    @ReferSerialTransfer(referCode="zydx-ex-grade")
    public Long getPunishType() {
        return punishType;
    }
    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    public String getPunishTypeName() {
        return punishTypeName;
    }

    public void setPunishTypeName(String punishTypeName) {
        this.punishTypeName = punishTypeName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }
    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrg() {
        return applyOrg;
    }

    public void setApplyOrg(String applyOrg) {
        this.applyOrg = applyOrg;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyPersonId() {
        return applyPersonId;
    }
    @ReferDeserialTransfer
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCode() {
        return code;
    }
    public void setCode(String code) {
        this.code = code;
    }

    public Date getPunishLastTime() {
        return punishLastTime;
    }

    public void setPunishLastTime(Date punishLastTime) {
        this.punishLastTime = punishLastTime;
    }

    public String getPushState() {
        return pushState;
    }

    public void setPushState(String pushState) {
        this.pushState = pushState;
    }

    public String getRmCode() {
        return rmCode;
    }

    public void setRmCode(String rmCode) {
        this.rmCode = rmCode;
    }

    public Long getRmId() {
        return rmId;
    }

    public void setRmId(Long rmId) {
        this.rmId = rmId;
    }
}
