package com.ejianc.foundation.support.api;

import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.hystrix.CustomerHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 客户档案API
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = CustomerHystrix.class)
public interface ICustomerApi {

    /**
     * 根据名称查询唯一匹配的客户信息
     *
     * @param name
     * @param tenantId
     * @return
     */
    @GetMapping("/api/customerApi/findOneByName")
    CommonResponse<CustomerVO> findOneByName(@RequestParam(value = "name") String name,
                                                 @RequestParam(value = "tenantId") Long tenantId);

    /**
     * 根据客户Id查询客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/customerApi/queryById")
    CommonResponse<CustomerVO> detailById(@RequestParam(value = "id") Long id);

    /**
     * 同步
     * @param
     * @return
     */
    @RequestMapping(value = "/api/customerApi/syncCustomer",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustomerVO> syncCustomer(@RequestBody CustomerVO customerVO);
}
