package com.ejianc.foundation.supplier.api;

import com.ejianc.foundation.supplier.hystrix.ISupplierZYHystrix;
import com.ejianc.foundation.supplier.vo.ContractInfoVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


/**
 * 正元供应商api服务接口
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-support-web", url="${common.env.feign-client-url}", path="ejc-support-web", fallback = ISupplierZYHystrix.class)
public interface ISupplierZYApi {

	/**
	 * 根据 合同信息 生成该合同的过程评价单
	 * 返回生成的过程评价单的主键id
	 *
	 * @param contractInfoVO
	 * @return 返回生成的过程评价单的主键id
	 */
	@RequestMapping(value = "/api/supplierZY/createGuoChengPingJia",method = RequestMethod.POST)
    CommonResponse<Long> createGuoChengPingJia(@RequestBody ContractInfoVO contractInfoVO);

	/**
	 * 同步
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/api/supplierZY/syncSuppler",method = RequestMethod.POST)
    CommonResponse<SupplierVO> syncSuppler(@RequestBody SupplierVO supplierVO);

}
