/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.bean.TenantSupplierEntity;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.service.ITenantSupplierService;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.supplier.vo.TenantSupplierVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.api.ICooperateEnterpriseApi;
import com.ejianc.foundation.usercenter.vo.CooperateEnterpriseVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tenantSupplier"})
public class TenantSupplierController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICooperateEnterpriseApi cooperateEnterpriseApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITenantSupplierService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierService supplierService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody List<TenantSupplierVO> saveOrUpdateVOs) {
        if (ListUtil.isEmpty(saveOrUpdateVOs)) {
            return CommonResponse.error((String)"\u5f15\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List entitys = BeanMapper.mapList(saveOrUpdateVOs, TenantSupplierEntity.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("originId", new Parameter("in", entitys.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toList())));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List dbData = this.service.queryList(queryParam);
        if (ListUtil.isNotEmpty((List)dbData)) {
            Set originIds = dbData.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toSet());
            entitys.removeIf(entity -> originIds.contains(entity.getOriginId()));
        }
        if (ListUtil.isNotEmpty((List)entitys)) {
            entitys.forEach(e -> {
                e.setCreateTime(null);
                e.setCreateUserCode(null);
                e.setUpdateTime(null);
                e.setUpdateUserCode(null);
                e.setTenantId(InvocationInfoProxy.getTenantid());
            });
            this.service.saveOrUpdateBatch(entitys);
            CommonResponse response = this.tenantApi.queryDetail(InvocationInfoProxy.getTenantid());
            TenantVO tenantVo = (TenantVO)response.getData();
            ArrayList<CooperateEnterpriseVO> vos = new ArrayList<CooperateEnterpriseVO>();
            for (TenantSupplierEntity entity2 : entitys) {
                CooperateEnterpriseVO vo = new CooperateEnterpriseVO();
                vo.setTenantId(entity2.getTenant());
                vo.setSupplierId(entity2.getOriginId().toString());
                vo.setCode(entity2.getCode());
                vo.setCooperationEnterpriseName(tenantVo.getName());
                vo.setcooperateEnterId(InvocationInfoProxy.getTenantid());
                vo.setApplyTime(new Date());
                vo.setApplyState("3");
                vos.add(vo);
            }
            this.logger.info("\u63a8\u9001\u751f\u6210\u4f9b\u65b9\u79df\u6237\u7684\u5408\u4f5c\u4fe1\u606f:" + JSONObject.toJSONString(vos));
            this.cooperateEnterpriseApi.createCooperate(vos);
        }
        return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TenantSupplierVO> queryDetail(Long id) {
        TenantSupplierEntity entity = (TenantSupplierEntity)((Object)this.service.selectById(id));
        SupplierVO supplierVO = this.supplierService.queryDetail(entity.getOriginId());
        TenantSupplierVO vo = (TenantSupplierVO)BeanMapper.map((Object)supplierVO, TenantSupplierVO.class);
        vo.setOriginId(entity.getOriginId());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenantSupplierVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TenantSupplierVO tenantSupplierVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TenantSupplierVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("businessScope");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TenantSupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("businessScope");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TenantSupplier-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTenantSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TenantSupplierVO>> refTenantSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("businessScope");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)(_con = JSONObject.parseObject((String)condition)).getString("inException"))) {
            param.getParams().put("inException", new Parameter("eq", (Object)_con.getBoolean("inException")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TenantSupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryExceptionList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TenantSupplierVO>> queryExceptionList(@RequestBody QueryParam param) {
        param.getParams().put("inException", new Parameter("eq", (Object)true));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        return this.queryList(param);
    }
}

