/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.bean.ProjectEntity;
import com.ejianc.foundation.share.mapper.ProjectMapper;
import com.ejianc.foundation.share.service.IProjectService;
import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectService")
public class ProjectServiceImpl
extends BaseServiceImpl<ProjectMapper, ProjectEntity>
implements IProjectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "project";
    private static final String BILL_TYPE_CODE = "BT211209000000001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ProjectMapper projectMapper;

    @Override
    public ProjectVO temporarySave(ProjectVO saveorUpdateVO) {
        ProjectEntity entity = (ProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProjectEntity.class));
        this.checkProject(entity);
        ProjectVO vo = this.save(entity, saveorUpdateVO);
        return vo;
    }

    private void checkProject(ProjectEntity entity) {
        QueryWrapper wrapper = new QueryWrapper();
        if (entity.getId() != null) {
            wrapper.ne((Object)"id", (Object)entity.getId());
        }
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq((Object)"project_name", (Object)entity.getProjectName());
        List check = this.list((Wrapper)wrapper);
        if (check != null && check.size() > 0) {
            throw new BusinessException("\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff01\uff01");
        }
    }

    @Override
    public ProjectVO saveData(ProjectVO saveorUpdateVO) {
        ProjectEntity entity = (ProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProjectEntity.class));
        this.checkProject(entity);
        OrgVO projectDepartment = null;
        if (entity.getId() == null || entity.getId() == 0L) {
            projectDepartment = this.generateProjectDepartment(saveorUpdateVO);
        } else if (saveorUpdateVO.getProjectDepartmentId() != null) {
            projectDepartment = (OrgVO)this.getRespData(this.orgApi.getOneById(entity.getProjectDepartmentId()), true, "\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            if (!saveorUpdateVO.getOrgId().equals(projectDepartment.getId())) {
                projectDepartment.setParentId(saveorUpdateVO.getOrgId());
            }
            if (!saveorUpdateVO.getProjectName().equals(projectDepartment.getName())) {
                projectDepartment.setName(saveorUpdateVO.getProjectName());
                projectDepartment.setShortName(saveorUpdateVO.getProjectName());
            }
        } else {
            projectDepartment = this.generateProjectDepartment(saveorUpdateVO);
        }
        if (projectDepartment != null) {
            if ("2".equals(entity.getStatus())) {
                projectDepartment.setProjectState(Integer.valueOf(1));
            } else {
                projectDepartment.setProjectState(Integer.valueOf(2));
            }
            CommonResponse resp = this.orgApi.saveOrgInfo(projectDepartment);
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
            }
            entity.setProjectDepartmentId(projectDepartment.getId());
        }
        ProjectVO vo = new ProjectVO();
        try {
            CommonResponse resp;
            Map<String, Object> memberMap = this.getMemberMap(saveorUpdateVO);
            if (!memberMap.isEmpty() && !(resp = this.employeeApi.manageProjectMembers(memberMap)).isSuccess()) {
                this.logger.info("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: {}", (Object)resp.getMsg());
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: " + resp.getMsg());
            }
            vo = this.save(entity, saveorUpdateVO);
        }
        catch (Exception e) {
            if (entity.getProjectDepartmentId() != null) {
                this.orgApi.delById(entity.getProjectDepartmentId());
            }
            this.logger.info("\u9879\u76ee\u4fdd\u5b58\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
        }
        return vo;
    }

    private Map<String, Object> getMemberMap(ProjectVO projectRegisterVO) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)projectRegisterVO.getMembersList())) {
            HashMap<String, ArrayList<RoleUserRelationVO>> moveMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            HashMap<String, ArrayList<RoleUserRelationVO>> parttimeMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            List<Object> relationList = null;
            RoleUserRelationVO tmp = null;
            for (Map member : projectRegisterVO.getMembersList()) {
                if (null == member.get("isAdd") || !"true".equals(member.get("isAdd"))) continue;
                tmp = new RoleUserRelationVO();
                tmp.setUserId(null != member.get("userId") ? Long.valueOf(member.get("userId").toString()) : null);
                tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                tmp.setAuthOrgId(projectRegisterVO.getProjectDepartmentId());
                tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                tmp.setRoleId(null != member.get("roleId") ? Long.valueOf(member.get("roleId").toString()) : null);
                if ("move".equals(member.get("type").toString())) {
                    relationList = (ArrayList<RoleUserRelationVO>)moveMap.get(tmp.getEmployeeId());
                    if (null == relationList) {
                        relationList = new ArrayList<RoleUserRelationVO>();
                    }
                    relationList.add(tmp);
                    moveMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
                    continue;
                }
                relationList = (List)parttimeMap.get(tmp.getEmployeeId());
                if (null == relationList) {
                    relationList = new ArrayList();
                }
                relationList.add(tmp);
                parttimeMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
            }
            if (!moveMap.isEmpty()) {
                HashMap<String, Serializable> moveData = new HashMap<String, Serializable>();
                moveData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                moveData.put("detail", moveMap);
                dataMap.put("moveMembers", moveData);
            }
            if (!parttimeMap.isEmpty()) {
                HashMap<String, Serializable> parttimeData = new HashMap<String, Serializable>();
                parttimeData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                parttimeData.put("detail", parttimeMap);
                dataMap.put("parttimeMembers", parttimeData);
            }
        }
        return dataMap;
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private OrgVO generateProjectDepartment(ProjectVO projectVO) {
        CommonResponse response = this.orgApi.getOneById(projectVO.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        projectDepartment.setParentId(projectVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(projectVO.getProjectName());
        projectDepartment.setShortName(projectVO.getProjectName());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        return projectDepartment;
    }

    public ProjectVO save(ProjectEntity entity, ProjectVO saveorUpdateVO) {
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setState(1);
        }
        if (saveorUpdateVO.getProjectPriceList() != null && saveorUpdateVO.getProjectPriceList().size() > 0) {
            ProjectPriceVO projectPriceVO = (ProjectPriceVO)saveorUpdateVO.getProjectPriceList().get(0);
            entity.setProjectBidWinPrice(projectPriceVO.getProjectBidWinPrice());
            entity.setCivilEngineering(projectPriceVO.getCivilEngineering());
            entity.setFix(projectPriceVO.getFix());
            entity.setWaterSupplyDrainage(projectPriceVO.getWaterSupplyDrainage());
            entity.setStrongCurrent(projectPriceVO.getStrongCurrent());
            entity.setHeateVentilation(projectPriceVO.getHeateVentilation());
            entity.setFixOther(projectPriceVO.getFixOther());
            entity.setDecorate(projectPriceVO.getDecorate());
            entity.setOther(projectPriceVO.getOther());
        } else {
            entity.setProjectBidWinPrice(null);
            entity.setCivilEngineering(null);
            entity.setFix(null);
            entity.setWaterSupplyDrainage(null);
            entity.setStrongCurrent(null);
            entity.setHeateVentilation(null);
            entity.setFixOther(null);
            entity.setDecorate(null);
            entity.setOther(null);
        }
        this.saveOrUpdate((Object)entity, false);
        ProjectVO vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
        vo.setProjectPriceList(saveorUpdateVO.getProjectPriceList());
        return vo;
    }

    @Override
    public CommonResponse<String> changeState(ProjectVO projectVO) {
        ProjectEntity e = (ProjectEntity)((Object)super.selectById((Serializable)projectVO.getId()));
        CommonResponse orgResp = this.orgApi.getOneById(e.getProjectDepartmentId());
        if (!orgResp.isSuccess()) {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO department = (OrgVO)orgResp.getData();
        String msg = "";
        if (projectVO.getState() == 1) {
            department.setState(Integer.valueOf(0));
            e.setState(0);
            msg = "\u505c\u7528\u6210\u529f\uff01";
        } else if (projectVO.getState() == 0) {
            department.setState(Integer.valueOf(1));
            e.setState(1);
            msg = "\u542f\u7528\u6210\u529f";
        } else {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u9879\u76ee\u72b6\u6001\uff01");
        }
        CommonResponse resp = this.orgApi.saveOrgInfo(department);
        if (!resp.isSuccess()) {
            throw new BusinessException("\u66f4\u6539\u9879\u76ee\u72b6\u6001\u5931\u8d25\u5931\u8d25\uff0c\u66f4\u65b0\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        super.saveOrUpdate((Object)e);
        return CommonResponse.success((String)msg);
    }

    @Override
    public CommonResponse<String> delProject(List<ProjectVO> vos) {
        String userType = InvocationInfoProxy.getUserType();
        if (!"1".equals(userType)) {
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\u64cd\u4f5c\u7ec8\u6b62\uff0c\u5f53\u524d\u767b\u9646\u4eba[userId-{}]\u65e0\u5220\u9664\u6743\u9650\u3002---------", (Object)InvocationInfoProxy.getUserid());
            return CommonResponse.error((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5220\u9664\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u6267\u884c\u5220\u9664\u64cd\u4f5c\u3002");
        }
        ArrayList<ProjectVO> list = new ArrayList<ProjectVO>();
        for (ProjectVO vo : vos) {
            ProjectEntity entity = (ProjectEntity)((Object)this.selectById(vo.getId()));
            vo = (ProjectVO)BeanMapper.map((Object)((Object)entity), ProjectVO.class);
            list.add(vo);
            if ("1".equals(vo.getState())) {
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff0c\u9879\u76ee\uff1a\u3010" + vo.getProjectName() + "\u3011\u4e3a\u542f\u7528\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01"));
            }
            CommonResponse resp = this.billTypeApi.checkQuote(BILL_TYPE_CODE, vo.getId());
            if (resp.isSuccess()) continue;
            this.logger.info("\u9879\u76ee\u7acb\u9879\u3010Id-{}\u3011\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u539f\u56e0\uff1a{}", (Object)vo.getId(), (Object)resp.getMsg());
            return CommonResponse.error((String)("\u9879\u76ee\uff1a" + vo.getProjectName() + "\u5f15\u7528\u68c0\u67e5\u5931\u8d25," + resp.getMsg() + "\uff0c\u5220\u9664\u64cd\u4f5c\u4e2d\u6b62."));
        }
        for (ProjectVO vo : list) {
            this.logger.info("\u6267\u884c\u9879\u76ee\u5220\u90e8\u9664\u64cd\u4f5c\uff0c\u5220\u9664\u9879\u76ee\u90e8[id-{}]", (Object)vo.getProjectDepartmentId());
            CommonResponse delResp = this.orgApi.delByOrgId(vo.getProjectDepartmentId());
            if (delResp.isSuccess()) continue;
            this.logger.error("\u5220\u9664\u9879\u76ee[id-{}]\u5bf9\u5e94\u9879\u76ee\u90e8[id-{}]\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{vo.getId(), vo.getProjectDepartmentId(), delResp.getMsg()});
            return CommonResponse.error((String)("\u9879\u76ee[" + vo.getProjectName() + "]\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u5bf9\u5e94\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\u3002"));
        }
        this.removeByIds(list.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Integer queryProjectNum(String signValue) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.projectMapper.queryProjectCount(tenantId, signValue);
    }
}

