/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.TenantSupplierEntity;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.service.ITenantSupplierService;
import com.ejianc.foundation.supplier.vo.PunishVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/supplierApi/"})
public class SupplierApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ITenantSupplierService tenantSupplierService;

    @PostMapping(value={"pushSupplierToBaseStore"})
    public CommonResponse<String> pushSupplierToBaseStore(@RequestBody SupplierVO supplierVO) {
        this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u4f01\u4e1a\u4f9b\u5e94\u5546pushSupplierToShare---{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)supplierVO.getSocialCreditCode()));
        if (ListUtil.isNotEmpty((List)this.supplierService.queryList(param))) {
            if (supplierVO.getPersonal().equals("p")) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + supplierVO.getSocialCreditCode() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u3010" + supplierVO.getSocialCreditCode() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
        }
        QueryParam paramName = new QueryParam();
        paramName.getParams().put("name", new Parameter("eq", (Object)supplierVO.getName()));
        if (ListUtil.isNotEmpty((List)this.supplierService.queryList(paramName))) {
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + supplierVO.getName() + "\u3011\u7684\u4f9b\u5e94\u5546\uff01"));
        }
        SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        se.setInException(false);
        this.supplierService.saveOrUpdate((Object)se, false);
        if (se.getCoordination().booleanValue()) {
            this.supplierService.supplierCollaboration((SupplierVO)BeanMapper.map((Object)((Object)se), SupplierVO.class));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @GetMapping(value={"judgeTaxpayerNumIsRepeat"})
    public CommonResponse<String> judgeTaxpayerNumIsRepeat(@RequestParam String taxpayerNum, @RequestParam String personal) {
        this.logger.info("\u5224\u91cd\u53c2\u6570\uff1asocialCreditCode={},personal={}", (Object)taxpayerNum, (Object)personal);
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)taxpayerNum));
        List supplierEntities = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            if ("p".equals(personal)) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4e2a\u4eba\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u3010" + taxpayerNum + "\u3011\u7684\u4f01\u4e1a\u4f9b\u5e94\u5546\uff01"));
        }
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u4e0d\u91cd\u590d\uff01");
    }

    @GetMapping(value={"querySupplierByIds"})
    public CommonResponse<List<SupplierVO>> querySupplierByIds(@RequestParam(value="ids") List<Long> ids) {
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,ids:" + ids);
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6761\u6570:" + entitys.size());
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"querySupplierDTOByIds"})
    public CommonResponse<List<SupplierDTO>> querySupplierDTOByIds(@RequestParam(value="ids") List<Long> ids) {
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,ids:" + ids);
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6761\u6570:" + entitys.size());
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @PostMapping(value={"queryPostSupplierByIds"})
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> queryPostSupplierByIds(@RequestBody Map<String, List<Long>> map) {
        List<Long> ids = map.get("ids");
        this.logger.info("\u63a5\u53d7\u5230\u7684\u53c2\u6570,ids:" + ids);
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6761\u6570:" + entitys.size());
        List dtos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dtos);
    }

    @PostMapping(value={"querySupplierByNames"})
    @ResponseBody
    public CommonResponse<List<SupplierDTO>> querySupplierByNames(@RequestBody List<String> names) {
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546 \u540d\u79f0 \u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f \u63a5\u53d7\u5230\u7684\u53c2\u6570,names:" + names);
        ArrayList vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"name", names);
        List entitys = this.supplierService.list((Wrapper)queryWrapper);
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546 \u540d\u79f0 \u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f \u6761\u6570:" + entitys.size());
        List dtos = BeanMapper.mapList((Iterable)entitys, SupplierDTO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01\uff01\uff01\uff01", (Object)dtos);
    }

    @PostMapping(value={"punishSupplier"})
    public CommonResponse<String> punishSupplier(@RequestBody PunishVO punishVO) {
        String punishVOStr = JSONObject.toJSONString((Object)punishVO);
        this.logger.info("\u4f9b\u5e94\u5546\u5904\u7f6e\u66f4\u65b0\u4f9b\u5e94\u5546\u5e93 ----- punishVOStr:" + punishVOStr);
        if (Objects.equals(punishVO.getSourceType(), "CG")) {
            TenantSupplierEntity supplierEntity = (TenantSupplierEntity)((Object)this.tenantSupplierService.selectById(punishVO.getSupplierId()));
            if (supplierEntity == null) {
                return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u672a\u5f15\u5165\uff0c\u4e0d\u5b58\u5728\uff01");
            }
            boolean inException = true;
            if (DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()).equals(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)punishVO.getExceptionEndDate()))) {
                inException = false;
            }
            supplierEntity.setGradeId(punishVO.getPunishGradeId());
            supplierEntity.setInException(inException);
            supplierEntity.setGradeName(punishVO.getPunishGrade());
            supplierEntity.setPunishDate(punishVO.getPunishDate());
            supplierEntity.setExceptionEndDate(punishVO.getExceptionEndDate());
            supplierEntity.setPunishType(punishVO.getPunishType());
            supplierEntity.setPunishId(punishVO.getId());
            this.tenantSupplierService.saveOrUpdate((Object)supplierEntity, false);
            return CommonResponse.success((String)"\u5904\u7f6e\u6210\u529f\uff01");
        }
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(punishVO.getSupplierId()));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        boolean inException = true;
        if (DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()).equals(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)punishVO.getExceptionEndDate()))) {
            inException = false;
        }
        supplierEntity.setGradeId(punishVO.getPunishGradeId());
        supplierEntity.setGradeName(punishVO.getPunishGrade());
        supplierEntity.setInException(inException);
        supplierEntity.setPunishDate(punishVO.getPunishDate());
        supplierEntity.setPunishId(punishVO.getId());
        supplierEntity.setExceptionEndDate(punishVO.getExceptionEndDate());
        supplierEntity.setPunishType(punishVO.getPunishType());
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u5904\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"returnSupplierToNormal"})
    public CommonResponse<String> returnSupplierToNormal(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName, @RequestParam(value="sourceType", required=false) String sourceType) {
        if (Objects.equals(sourceType, "CG")) {
            TenantSupplierEntity supplierEntity = (TenantSupplierEntity)((Object)this.tenantSupplierService.selectById(supplierId));
            if (supplierEntity == null) {
                return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u672a\u5f15\u5165\uff0c\u4e0d\u5b58\u5728\uff01");
            }
            supplierEntity.setGradeId(gradeId);
            supplierEntity.setGradeName(gradeName);
            supplierEntity.setExceptionEndDate(null);
            supplierEntity.setInException(false);
            supplierEntity.setPunishType(null);
            supplierEntity.setPunishId(null);
            this.tenantSupplierService.saveOrUpdate((Object)supplierEntity, false);
            return CommonResponse.success((String)"\u79fb\u9664\u4f9b\u5e94\u5546\u5f02\u5e38\u6807\u7b7e\u6210\u529f\uff01");
        }
        this.logger.info("\u79fb\u9664\u4f9b\u5e94\u5546\u5f02\u5e38\u6807\u7b7e");
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        supplierEntity.setInException(false);
        supplierEntity.setExceptionEndDate(null);
        supplierEntity.setPunishType(null);
        supplierEntity.setPunishId(null);
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u79fb\u9664\u4f9b\u5e94\u5546\u5f02\u5e38\u6807\u7b7e\u6210\u529f\uff01");
    }

    @GetMapping(value={"upgradeSupplier"})
    public CommonResponse<String> upgradeSupplier(@RequestParam(value="supplierId") Long supplierId, @RequestParam(value="gradeId") Long gradeId, @RequestParam(value="gradeName") String gradeName, @RequestParam(value="sourceType", required=false) String sourceType) {
        this.logger.info("\u8bc4\u7ea7\u66f4\u65b0\u4f9b\u5e94\u5546\u5e93");
        if (Objects.equals(sourceType, "CG")) {
            TenantSupplierEntity supplierEntity = (TenantSupplierEntity)((Object)this.tenantSupplierService.selectById(supplierId));
            if (supplierEntity == null) {
                return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u672a\u5f15\u5165\uff0c\u4e0d\u5b58\u5728\uff01");
            }
            supplierEntity.setGradeId(gradeId);
            supplierEntity.setGradeName(gradeName);
            this.tenantSupplierService.saveOrUpdate((Object)supplierEntity, false);
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        supplierEntity.setGradeId(gradeId);
        supplierEntity.setGradeName(gradeName);
        this.supplierService.saveOrUpdate((Object)supplierEntity, false);
        return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u8bc4\u7ea7\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @GetMapping(value={"getSupplierInfo"})
    @ResponseBody
    public CommonResponse<SupplierVO> getSupplierInfo(@RequestParam(value="supplierId") Long supplierId) {
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        SupplierVO vo = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"whetherSupplierCoo"})
    @ResponseBody
    public CommonResponse<Boolean> whetherSupplierCoo(@RequestParam(value="supplierId") Long supplierId) {
        boolean coo = false;
        SupplierEntity supplierEntity = (SupplierEntity)((Object)this.supplierService.selectById(supplierId));
        if (supplierEntity == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        if (StringUtils.isNotEmpty((CharSequence)supplierEntity.getSystemId()) && supplierEntity.getCoordination() != null && supplierEntity.getCoordination().booleanValue()) {
            coo = true;
        }
        this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546id\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u662f\u5426\u771f\u6b63\u534f\u540c\u6210\u529f{}===>>{}", (Object)coo, (Object)JSONObject.toJSONString((Object)((Object)supplierEntity)));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)coo);
    }

    @GetMapping(value={"checkTaxpayerNumOrNameIsSame"})
    public CommonResponse<Boolean> checkTaxpayerNumOrNameIsSame(@RequestParam(value="taxpayerNum") String taxpayerNum, @RequestParam(value="name") String name) {
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)taxpayerNum));
        List supplierEntities = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            if (((SupplierEntity)((Object)supplierEntities.get(0))).getName().equals(name)) {
                return CommonResponse.success((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u548c\u540d\u79f0\u4e00\u81f4", (Object)true);
            }
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e00\u81f4\uff0c\u4f46\u662f\u540d\u79f0\u4e0d\u4e00\u81f4\u7684\u4f9b\u5e94\u5546,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01", (Object)false);
        }
        param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)name));
        supplierEntities = this.supplierService.queryList(param);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            if (((SupplierEntity)((Object)supplierEntities.get(0))).getSocialCreditCode().equals(taxpayerNum)) {
                return CommonResponse.success((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u548c\u540d\u79f0\u4e00\u81f4", (Object)true);
            }
            return CommonResponse.success((String)"\u4f9b\u5e94\u5546\u5e93\u5b58\u5728\u540d\u79f0\u4e00\u81f4\uff0c\u4f46\u662f\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\u7684\u4f9b\u5e94\u5546,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\uff01", (Object)false);
        }
        return CommonResponse.success((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u4f9b\u5e94\u5546\uff0c\u8ba4\u4e3a\u4e00\u81f4", (Object)true);
    }

    @GetMapping(value={"getSupplierBySupplierTenantId"})
    @ResponseBody
    public CommonResponse<SupplierDTO> getSupplierBySupplierTenantId(@RequestParam Long supplierTenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenant", Parameter.getEqInstance((Object)supplierTenantId));
        List list = this.supplierService.queryList(param, false);
        SupplierDTO res = null;
        if (ListUtil.isNotEmpty((List)list)) {
            res = (SupplierDTO)BeanMapper.map(list.get(0), SupplierDTO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
        }
        return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"getBaseSupplierIdByTenantId"})
    @ResponseBody
    public CommonResponse<List<Long>> getBaseSupplierIdByTenantId(@RequestParam Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", Parameter.getEqInstance((Object)tenantId));
        List list = this.tenantSupplierService.queryList(param, false);
        List<Object> supplierIds = new ArrayList();
        if (ListUtil.isNotEmpty((List)list)) {
            supplierIds = list.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", supplierIds);
    }

    @GetMapping(value={"getReferSupplierIdsBySupplierId"})
    @ResponseBody
    public CommonResponse<List<Long>> getReferSupplierIdsBySupplierId(@RequestParam(value="supplierId") Long supplierId) {
        QueryParam param = new QueryParam();
        param.getParams().put("originId", Parameter.getEqInstance((Object)supplierId));
        List<Object> supplierIds = new ArrayList();
        List list = this.tenantSupplierService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            supplierIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", supplierIds);
    }

    @PostMapping(value={"afterSupplierChangeToSave"})
    @ResponseBody
    public CommonResponse<String> afterSupplierChangeToSave(@RequestBody SupplierVO supplierVO) {
        SupplierEntity entity = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
        this.supplierService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }
}

