/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.supplier.bean.BrandEntity;
import com.ejianc.foundation.supplier.bean.ProductionEntity;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.TenantSupplierEntity;
import com.ejianc.foundation.supplier.mapper.SupplyMapper;
import com.ejianc.foundation.supplier.service.IProductionService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.service.ITenantSupplierService;
import com.ejianc.foundation.supplier.vo.BrandReportVO;
import com.ejianc.foundation.supplier.vo.CanInReportVO;
import com.ejianc.foundation.supplier.vo.SupplierCooperateVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="supplyService")
public class SupplierServiceImpl
extends BaseServiceImpl<SupplyMapper, SupplierEntity>
implements ISupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITenantSupplierService tenantSupplierService;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Value(value="${sendMessageTemplateCode}")
    private String sendMessageTemplateCode;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private ITenantApi tenantApi;

    @Override
    public CommonResponse<String> supplierCollaboration(SupplierVO supplierVO) {
        CommonResponse back;
        EnterpriseVO enterpriseVO = new EnterpriseVO();
        enterpriseVO.setName(supplierVO.getName());
        enterpriseVO.setId(Long.valueOf(IdWorker.getId()));
        enterpriseVO.setCode(String.valueOf(enterpriseVO.getId() + 1L));
        enterpriseVO.setTelephone(supplierVO.getTenantPhone());
        enterpriseVO.setSocialCreditCode(supplierVO.getSocialCreditCode());
        enterpriseVO.setExamineState("1");
        enterpriseVO.setAuditName(supplierVO.getLegal());
        enterpriseVO.setLegalName(supplierVO.getLegal());
        enterpriseVO.setRegisterPhoneNum(supplierVO.getTenantPhone());
        enterpriseVO.setSupplierId(supplierVO.getId());
        enterpriseVO.setArea(supplierVO.getAddress());
        enterpriseVO.setTaxCode(supplierVO.getEnterpriseNatureName());
        enterpriseVO.setIndustry(supplierVO.getEnterpriseType());
        enterpriseVO.setDescription(supplierVO.getCanInMemo());
        enterpriseVO.setCommitTime(supplierVO.getRegisterTime());
        String msg = "\u751f\u6210\u4f9b\u65b9\u8d26\u53f7\u6210\u529f\uff01";
        String regPhone = supplierVO.getTenantPhone();
        String name = supplierVO.getLegal();
        if (supplierVO.getTenantUserId() != null) {
            enterpriseVO.setUserId(supplierVO.getTenantUserId());
            enterpriseVO.setId(Long.valueOf(Long.parseLong(supplierVO.getSystemId())));
            enterpriseVO.setTenantId(supplierVO.getTenant());
            msg = "\u4f9b\u65b9\u8d26\u53f7\u66f4\u65b0\u6210\u529f\uff01";
        }
        if ((back = this.enterpriseApi.supplierCollaboration(enterpriseVO)).isSuccess()) {
            this.logger.info("\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u5f00\u59cb----------->");
            EnterpriseVO enterprise = (EnterpriseVO)back.getData();
            SupplierEntity entity = (SupplierEntity)((Object)this.getById(supplierVO.getId()));
            entity.setTenant(enterprise.getTenantId());
            entity.setTenantName(supplierVO.getName());
            entity.setTenantUserName(supplierVO.getLegal());
            entity.setTenantUserId(enterprise.getUserId());
            entity.setSystemId(enterprise.getId().toString());
            entity.setTenantPhone(supplierVO.getTenantPhone());
            entity.setCoordination(true);
            this.saveOrUpdate((Object)entity, false);
            QueryParam param = new QueryParam();
            param.getParams().put("originId", Parameter.getEqInstance((Object)entity.getId()));
            List tenantSupplierEntities = this.tenantSupplierService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)tenantSupplierEntities)) {
                for (TenantSupplierEntity tenantSupplier : tenantSupplierEntities) {
                    tenantSupplier.setTenant(enterprise.getTenantId());
                    tenantSupplier.setTenantPhone(supplierVO.getTenantPhone());
                    tenantSupplier.setTenantName(supplierVO.getName());
                    tenantSupplier.setTenantUserId(enterprise.getUserId());
                    tenantSupplier.setTenantUserName(supplierVO.getLegal());
                    tenantSupplier.setSystemId(enterprise.getId().toString());
                    tenantSupplier.setCoordination(true);
                }
                this.tenantSupplierService.saveOrUpdateBatch(tenantSupplierEntities);
            }
            this.logger.info("----------->\u56de\u5199\u4f9b\u65b9\u79df\u6237\u4fe1\u606f\u7ed3\u675f");
            this.updateOtherSupplierCooInfo(enterprise.getUserId(), regPhone, name);
            return CommonResponse.success((String)msg);
        }
        return CommonResponse.error((String)back.getMsg());
    }

    private void updateOtherSupplierCooInfo(Long userId, String regPhone, String name) {
        List tenantSupplierEntities;
        QueryParam param = new QueryParam();
        param.getParams().put("tenantUserId", Parameter.getEqInstance((Object)userId));
        List supplierEntities = this.queryList(param, false);
        if (ListUtil.isNotEmpty((List)supplierEntities)) {
            for (SupplierEntity supplierEntity : supplierEntities) {
                supplierEntity.setTenantUserName(name);
                supplierEntity.setTenantPhone(regPhone);
            }
            this.saveOrUpdateBatch(supplierEntities);
        }
        if (ListUtil.isNotEmpty((List)(tenantSupplierEntities = this.tenantSupplierService.queryList(param, false)))) {
            for (TenantSupplierEntity tenantSupplier : tenantSupplierEntities) {
                tenantSupplier.setTenantUserName(name);
                tenantSupplier.setTenantPhone(regPhone);
            }
            this.tenantSupplierService.saveOrUpdateBatch(tenantSupplierEntities);
        }
    }

    @Override
    public List<BrandReportVO> queryBrandTypeList(Page pages, QueryWrapper queryWrapper, List<Long> supplierIds) {
        return ((SupplyMapper)this.baseMapper).queryBrandTypeList(pages, queryWrapper, supplierIds);
    }

    @Override
    public List<BrandReportVO> queryBrandList(List<Long> supplierIds) {
        return ((SupplyMapper)this.baseMapper).queryBrandList(supplierIds);
    }

    @Override
    public List<CanInReportVO> querySupplierList(Page pages, QueryWrapper queryWrapper, Long brandId, List<Long> supplierIds) {
        return ((SupplyMapper)this.baseMapper).querySupplierList(pages, queryWrapper, brandId, supplierIds);
    }

    @Override
    public SupplierVO queryDetail(Long id) {
        QueryParam param;
        SupplierEntity entity = (SupplierEntity)((Object)super.selectById((Serializable)id));
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            List ids = entity.getBrandList().stream().map(x -> x.getId()).collect(Collectors.toList());
            param = new QueryParam();
            param.getParams().put("brandId", new Parameter("in", ids));
            List productionList = this.productionService.queryList(param);
            Map<Long, List<ProductionEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x -> x.getBrandId()));
            for (BrandEntity brand : entity.getBrandList()) {
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
            entity.setProductionList(null);
        }
        SupplierVO resVo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        param = new QueryParam();
        param.getParams().put("originId", Parameter.getEqInstance((Object)entity.getId()));
        List tenantSupplierEntities = this.tenantSupplierService.queryList(param, false);
        List supplierCooperateVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tenantSupplierEntities)) {
            supplierCooperateVOList = BeanMapper.mapList((Iterable)tenantSupplierEntities, SupplierCooperateVO.class);
            supplierCooperateVOList.forEach(e -> e.setTenantName(((TenantVO)this.tenantApi.queryDetail(e.getTenantId()).getData()).getName()));
            resVo.setCooperateList(supplierCooperateVOList);
        }
        return resVo;
    }
}

