/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.supplier.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.bean.SupplierEntity;
import com.ejianc.foundation.supplier.bean.TenantSupplierEntity;
import com.ejianc.foundation.supplier.service.IBrandService;
import com.ejianc.foundation.supplier.service.IProductionService;
import com.ejianc.foundation.supplier.service.ISupplierService;
import com.ejianc.foundation.supplier.service.ITenantSupplierService;
import com.ejianc.foundation.supplier.vo.BrandReportVO;
import com.ejianc.foundation.supplier.vo.BrandVO;
import com.ejianc.foundation.supplier.vo.CanInReportVO;
import com.ejianc.foundation.supplier.vo.ProductionVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplier"})
public class SupplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISupplierService service;
    @Autowired
    private ITenantSupplierService tenantSupplierService;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdate(@RequestBody SupplierVO saveOrUpdateVO) {
        SupplierEntity entity = (SupplierEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SupplierEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SupplierVO vo = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplierVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SupplierVO supplierVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("businessScope");
        ArrayList supplierIds = new ArrayList();
        if ("999999".equals(InvocationInfoProxy.getTenantid().toString())) {
            IPage page = this.service.queryPage(param, false);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.tenantSupplierService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        ArrayList resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            page.getRecords().forEach(e -> {
                e.setId(e.getOriginId());
                resList.add(BeanMapper.map((Object)e, SupplierVO.class));
            });
        }
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryExceptionList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> queryExceptionList(@RequestBody QueryParam param) {
        param.getParams().put("inException", new Parameter("eq", (Object)true));
        return this.queryList(param);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("businessScope");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Supply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSupplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> refSupplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("socialCreditCode");
        fuzzyFields.add("supplyContent");
        fuzzyFields.add("businessScope");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (StringUtils.isNotEmpty((CharSequence)_con.getString("inException"))) {
                param.getParams().put("inException", new Parameter("eq", (Object)_con.getBoolean("inException")));
            }
            if (StringUtils.isNotEmpty((CharSequence)_con.getString("import"))) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                List list = this.tenantSupplierService.queryList(queryParam, false);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    param.getParams().put("id", new Parameter("not_in", list.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toList())));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/supplierCollaboration"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> supplierCollaboration(@RequestBody SupplierVO supplierVO) {
        return this.service.supplierCollaboration(supplierVO);
    }

    @RequestMapping(value={"/querySupplierBySocialCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> querySupplierBySocialCode(@RequestParam String socialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"social_credit_code", (Object)socialCode);
        List list = this.service.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            SupplierVO supplierVo = (SupplierVO)BeanMapper.map(list.get(0), SupplierVO.class);
            return CommonResponse.success((Object)supplierVo);
        }
        return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546");
    }

    @RequestMapping(value={"/queryBrandList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryBrandList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("brandTypeName");
        List<Long> supplierIds = new ArrayList<Long>();
        if (!"999999".equals(InvocationInfoProxy.getTenantid().toString())) {
            QueryParam param2 = new QueryParam();
            param2.getParams().put("tenantId", Parameter.getEqInstance((Object)InvocationInfoProxy.getTenantid()));
            List list = this.tenantSupplierService.queryList(param2, false);
            if (ListUtil.isNotEmpty((List)list)) {
                supplierIds = list.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toList());
            }
            this.logger.info("\u5f53\u524d\u79df\u6237--" + InvocationInfoProxy.getTenantid() + "  \u5f15\u5165\u4f9b\u5e94\u5546id--" + JSONObject.toJSONString(supplierIds));
        }
        ArrayList<BrandReportVO> resList = new ArrayList<BrandReportVO>();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BrandReportVO> typeList = this.service.queryBrandTypeList(page, wrapper, supplierIds);
        resList.addAll(typeList);
        List<BrandReportVO> brandList = this.service.queryBrandList(supplierIds);
        if (CollectionUtils.isNotEmpty(brandList)) {
            List sourceIds = brandList.stream().map(BaseVO::getId).collect(Collectors.toList());
            JSONObject paramStr = new JSONObject();
            paramStr.put("sourceIds", sourceIds);
            ArrayList<String> sourceTypeList = new ArrayList<String>();
            sourceTypeList.add("pinpailogo");
            paramStr.put("sourceTypeList", (Object)JSONArray.toJSONString(sourceTypeList));
            CommonResponse attachListResp = this.attachmentApi.queryAllBySourceIdList(paramStr);
            Map<Long, Long> map = ((List)attachListResp.getData()).stream().collect(Collectors.toMap(AttachmentVO::getSourceId, AttachmentVO::getId));
            brandList.forEach(e -> e.setLogoUrl(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + map.get(e.getId())));
            resList.addAll(brandList);
        }
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> querySupplierList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplierName");
        Long brandId = Long.valueOf(((Parameter)param.getParams().get("brandId")).getValue().toString());
        param.getParams().remove("brandId");
        List<Long> supplierIds = new ArrayList<Long>();
        if (!"999999".equals(InvocationInfoProxy.getTenantid().toString())) {
            QueryParam param2 = new QueryParam();
            param2.getParams().put("tenantId", Parameter.getEqInstance((Object)InvocationInfoProxy.getTenantid()));
            List list = this.tenantSupplierService.queryList(param2, false);
            if (ListUtil.isNotEmpty((List)list)) {
                supplierIds = list.stream().map(TenantSupplierEntity::getOriginId).collect(Collectors.toList());
            }
            this.logger.info("\u5f53\u524d\u79df\u6237--" + InvocationInfoProxy.getTenantid() + "  \u5f15\u5165\u4f9b\u5e94\u5546id--" + JSONObject.toJSONString(supplierIds));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CanInReportVO> resList = this.service.querySupplierList(page, wrapper, brandId, supplierIds);
        JSONObject res = new JSONObject();
        res.put("records", resList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryProductionList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryProductionList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("productName");
        param.getFuzzyFields().add("supplyMode");
        param.getFuzzyFields().add("priceRange");
        IPage page = this.productionService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refBrandData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BrandVO>> refBrandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("brandTypeName");
        param.getFuzzyFields().add("brandName");
        param.getFuzzyFields().add("brandCode");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.brandService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

